/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.runtime;

import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.deployment.DeploymentImpl;
import fi.testee.runtime.DependencyInjectionRealm;
import fi.testee.spi.ReleaseCallbackHandler;
import fi.testee.spi.Releaser;
import fi.testee.spi.RuntimeLifecycleListener;
import java.util.Collections;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(TestRuntime.class);
    private static TestRuntime instance;
    private final BeanArchiveDiscovery beanArchiveDiscovery = new BeanArchiveDiscovery();
    private final DependencyInjectionRealm realm;
    private final Releaser releaser = new Releaser();

    public static synchronized TestRuntime instance() {
        if (instance == null) {
            instance = new TestRuntime();
        }
        return instance;
    }

    private TestRuntime() {
        SimpleServiceRegistry serviceRegistry = new SimpleServiceRegistry();
        this.realm = new DependencyInjectionRealm().init((ServiceRegistry)serviceRegistry, this.beanArchiveDiscovery, Environments.SE, Collections.emptySet(), DeploymentImpl.UNMODIFIED);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestRuntime.this.releaser.release();
                TestRuntime.this.realm.shutdown();
            }
        });
        LOG.trace("Notifying runtime lifecycle listeners about start");
        this.realm.getInstancesOf(RuntimeLifecycleListener.class, (ReleaseCallbackHandler)this.releaser).forEach(RuntimeLifecycleListener::onRuntimeStarted);
    }

    public BeanArchiveDiscovery getBeanArchiveDiscorvery() {
        return this.beanArchiveDiscovery;
    }
}

