/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.runtime;

import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.deployment.DeploymentImpl;
import fi.testee.ejb.EjbContainer;
import fi.testee.jdbc.TestDataSource;
import fi.testee.runtime.DatabaseMigration;
import fi.testee.runtime.DeferredDependencyInjection;
import fi.testee.runtime.DependencyInjectionRealm;
import fi.testee.runtime.ManualResourceProviderBuilder;
import fi.testee.runtime.TestDataSetup;
import fi.testee.runtime.TestInstanceRealm;
import fi.testee.runtime.TestRuntime;
import fi.testee.runtime.TransactionalContext;
import fi.testee.services.ResourceInjectionServicesImpl;
import fi.testee.spi.ConnectionFactory;
import fi.testee.spi.DataSourceMigrator;
import fi.testee.spi.DependencyInjection;
import fi.testee.spi.ReleaseCallbackHandler;
import fi.testee.spi.Releaser;
import fi.testee.spi.ResourceProvider;
import fi.testee.spi.scope.TestSetupScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSetup
extends DependencyInjectionRealm {
    private static final Logger LOG = LoggerFactory.getLogger(TestSetup.class);
    private final Map<Class<? extends ConnectionFactory>, ConnectionFactory> connectionFactories = new HashMap<Class<? extends ConnectionFactory>, ConnectionFactory>();
    private final Class<?> setupClass;
    private final TestRuntime runtime;
    private Releaser setupReleaser = new Releaser();

    public TestSetup(Class<?> setupClass, TestRuntime runtime) {
        this.setupClass = setupClass;
        this.runtime = runtime;
    }

    public TestSetup init() {
        SimpleServiceRegistry serviceRegistry = new SimpleServiceRegistry();
        ResourceProvider setupResources = this.createSetupResources(false);
        serviceRegistry.add(ResourceInjectionServices.class, (Service)new ResourceInjectionServicesImpl(Arrays.asList(setupResources)));
        BeanArchiveDiscovery beanArchiveDiscovery = this.runtime.getBeanArchiveDiscorvery();
        super.init((ServiceRegistry)serviceRegistry, beanArchiveDiscovery, Environments.SE, Collections.emptySet(), DeploymentImpl.UNMODIFIED);
        this.setupTestData(setupResources);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTestData(ResourceProvider setupResources) {
        try {
            Releaser testDataReleaser = new Releaser();
            TransactionalContext context = this.getInstanceOf(TransactionalContext.class, (ReleaseCallbackHandler)testDataReleaser);
            Annotation[] scopes = new Annotation[]{TestSetupScope.INSTANCE};
            context.initialize(EjbContainer.IDENTITY, Collections.emptySet(), DeploymentImpl.UNMODIFIED, Arrays.asList(setupResources), scopes);
            try {
                Set<DataSourceMigrator> migrators = this.getInstancesOf(DataSourceMigrator.class, (ReleaseCallbackHandler)testDataReleaser);
                context.run((clazz, testDataSetupRealm) -> {
                    DatabaseMigration.migrateDataSources(clazz, migrators, testDataSetupRealm.getServiceRegistry());
                    TestDataSetup.setupTestData(clazz, testDataSetupRealm.getServiceRegistry());
                    return null;
                });
                context.flushEntityManagers();
            }
            finally {
                testDataReleaser.release();
            }
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    private ResourceProvider createSetupResources(boolean rollbackTransactions) {
        return ManualResourceProviderBuilder.manualResourceProvider().put("testeefi/setup/class", this.setupClass).put("testeefi/setup/beanArchiveDiscovery", this.runtime.getBeanArchiveDiscorvery()).put("testeefi/setup/connectionFactoryManager", this::connectionFactoryManager).put("testeefi/setup/dependencyInjection", this.testSetupDependencyInjection()).put("testeefi/setup/annotationScanner", this.runtime.getBeanArchiveDiscorvery()::getClassesWith).put("testeefi/setup/rollbackTransactions", rollbackTransactions).build();
    }

    private DependencyInjection testSetupDependencyInjection() {
        return new DeferredDependencyInjection(() -> this);
    }

    private synchronized ConnectionFactory connectionFactoryManager(TestDataSource testDataSource) {
        if (!this.connectionFactories.containsKey(testDataSource.factory())) {
            this.connectionFactories.put(testDataSource.factory(), this.getInstanceOf(testDataSource.factory(), (ReleaseCallbackHandler)this.setupReleaser));
        }
        return this.connectionFactories.get(testDataSource.factory());
    }

    public TestInstance prepareTestInstance(String id, Object testInstance, Method method) {
        LOG.debug("Instantiating test run '{}' for class {}", (Object)id, (Object)testInstance.getClass().getName());
        return new TestInstanceRealm().init(this.runtime.getBeanArchiveDiscorvery(), id, testInstance, method, Arrays.asList(this.createSetupResources(true)));
    }

    @Override
    public void shutdown() {
        this.setupReleaser.release();
        super.shutdown();
    }

    public static interface TestInstance {
        public <T> T create(Class<T> var1, ReleaseCallbackHandler var2);

        public void shutdown();

        public String getId();
    }
}

