/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.runtime;

import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.deployment.EjbDescriptorImpl;
import fi.testee.ejb.EjbContainer;
import fi.testee.ejb.EjbDescriptorHolder;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.jpa.PersistenceUnitDiscovery;
import fi.testee.runtime.DependencyInjectionRealm;
import fi.testee.services.EjbInjectionServicesImpl;
import fi.testee.services.EjbServicesImpl;
import fi.testee.services.ExecutorServicesImpl;
import fi.testee.services.JpaInjectionServicesImpl;
import fi.testee.services.ProxyServicesImpl;
import fi.testee.services.ResourceInjectionServicesImpl;
import fi.testee.services.SecurityServicesImpl;
import fi.testee.services.TransactionServicesImpl;
import fi.testee.spi.BeansXmlModifier;
import fi.testee.spi.DependencyInjection;
import fi.testee.spi.ReleaseCallbackHandler;
import fi.testee.spi.Releaser;
import fi.testee.spi.ResourceProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalContext {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalContext.class);
    @Resource(mappedName="testeefi/setup/class")
    private Class<?> testSetupClass;
    @Resource(mappedName="testeefi/setup/beanArchiveDiscovery")
    private BeanArchiveDiscovery beanArchiveDiscovery;
    @Inject
    @Any
    private Instance<ResourceProvider> resourceProvidersInstance;
    private DependencyInjectionRealm realm;
    private EjbContainer ejbContainer;

    public void initialize(EjbContainer.SessionBeanModifier sessionBeanModifier, Collection<Metadata<Extension>> extensions, BeansXmlModifier beansXmlModifier, Collection<ResourceProvider> setupResolvers, Annotation ... scopes) {
        LOG.debug("Initializing new transactional context for {}", this.testSetupClass);
        this.ejbContainer = new EjbContainer(this.beanArchiveDiscovery.getSessionBeans());
        HashSet<ResourceProvider> resourceProviders = new HashSet<ResourceProvider>(setupResolvers);
        Arrays.stream(scopes).forEach(it -> this.resourceProvidersInstance.select(new Annotation[]{it}).forEach(resourceProviders::add));
        LOG.trace("Resource providers: {}", resourceProviders);
        this.realm = new DependencyInjectionRealm().init(TransactionalContext.createInstanceServiceRegistry(resourceProviders, this.beanArchiveDiscovery, this.ejbContainer::lookupDescriptor, this.ejbContainer::createInstance), this.beanArchiveDiscovery, Environments.EE_INJECT, extensions, beansXmlModifier);
        this.ejbContainer.init(this::holderResolver, this::cdiInjection, this::resourceInjection, this::jpaInjection, sessionBeanModifier, this::contextFor);
    }

    private <T> EjbDescriptorHolder<T> holderResolver(EjbDescriptorImpl<T> desc) {
        BeanManagerImpl archive = this.realm.findArchiveFor(desc.getBeanClass());
        SessionBean sessionBean = archive.getBean(desc);
        if (sessionBean == null) {
            throw new TestEEfiException("Failed to find session bean for " + desc);
        }
        return new EjbDescriptorHolder<T>(desc, sessionBean, archive);
    }

    private Collection<ResourceReference<?>> cdiInjection(final Object o) {
        final Releaser r = new Releaser();
        this.realm.inject(o, (ReleaseCallbackHandler)r);
        return Arrays.asList(new ResourceReference<Object>(){

            public Object getInstance() {
                return o;
            }

            public void release() {
                r.release();
            }
        });
    }

    private <T> CreationalContextImpl<T> contextFor(Contextual<T> ctx, ReleaseCallbackHandler releaser) {
        return this.realm.contextFor(ctx, releaser);
    }

    private Object jpaInjection(Field field, Bean<?> bean, BeanManagerImpl beanManager) {
        return ((JpaInjectionServices)this.realm.getServiceRegistry().get(JpaInjectionServices.class)).registerPersistenceContextInjectionPoint(this.injectionPointOf(field, bean, beanManager)).createResource().getInstance();
    }

    private FieldInjectionPoint<Object, ?> injectionPointOf(Field f, Bean<?> bean, BeanManagerImpl beanManager) {
        EnhancedAnnotatedType type = beanManager.createEnhancedAnnotatedType(bean.getBeanClass());
        EnhancedAnnotatedField eaf = type.getDeclaredEnhancedField(f.getName());
        return InjectionPointFactory.instance().createFieldInjectionPoint(eaf, bean, bean.getBeanClass(), beanManager);
    }

    private <T, X> Object resourceInjection(Field field, Bean<?> bean, BeanManagerImpl beanManager) {
        return ((ResourceInjectionServices)this.realm.getServiceRegistry().get(ResourceInjectionServices.class)).registerResourceInjectionPoint(this.injectionPointOf(field, bean, beanManager)).createResource().getInstance();
    }

    private static ServiceRegistry createInstanceServiceRegistry(Collection<ResourceProvider> resourceProviders, BeanArchiveDiscovery beanArchiveDiscovery, EjbInjectionServicesImpl.EjbLookup ejbLookup, EjbInjectionServicesImpl.EjbFactory ejbFactory) {
        SimpleServiceRegistry serviceRegistry = new SimpleServiceRegistry();
        serviceRegistry.add(ResourceInjectionServices.class, (Service)new ResourceInjectionServicesImpl(resourceProviders));
        JpaInjectionServicesImpl jpaInjectionService = TransactionalContext.createJpaInjectionService(beanArchiveDiscovery, (ResourceInjectionServices)serviceRegistry.get(ResourceInjectionServices.class));
        serviceRegistry.add(JpaInjectionServices.class, (Service)jpaInjectionService);
        serviceRegistry.add(JpaInjectionServicesImpl.class, (Service)jpaInjectionService);
        serviceRegistry.add(EjbInjectionServices.class, (Service)new EjbInjectionServicesImpl(ejbLookup, ejbFactory));
        serviceRegistry.add(TransactionServices.class, (Service)new TransactionServicesImpl());
        serviceRegistry.add(SecurityServices.class, (Service)new SecurityServicesImpl());
        serviceRegistry.add(ProxyServices.class, (Service)new ProxyServicesImpl());
        serviceRegistry.add(ExecutorServices.class, (Service)new ExecutorServicesImpl());
        serviceRegistry.add(EjbServices.class, (Service)new EjbServicesImpl(ejbFactory));
        return serviceRegistry;
    }

    private static JpaInjectionServicesImpl createJpaInjectionService(BeanArchiveDiscovery beanArchiveDiscovery, ResourceInjectionServices resourceInjectionServices) {
        PersistenceUnitDiscovery persistenceUnitDiscovery = new PersistenceUnitDiscovery(beanArchiveDiscovery, resourceInjectionServices);
        return new JpaInjectionServicesImpl(persistenceUnitDiscovery);
    }

    public <T> T run(TransactionRunnable<T> runnable) {
        return runnable.run(this.testSetupClass, this.realm);
    }

    @PreDestroy
    public void shutdown() {
        LOG.debug("Shutting down transactional context for {}", this.testSetupClass);
        if (this.ejbContainer != null) {
            this.ejbContainer.shutdown();
        }
        if (this.realm != null) {
            this.realm.shutdown();
        }
    }

    public void flushEntityManagers() {
        ((JpaInjectionServicesImpl)this.realm.getServiceRegistry().get(JpaInjectionServicesImpl.class)).flush();
    }

    public DependencyInjection getDependencyInjection() {
        return this.realm;
    }

    public static interface TransactionRunnable<T> {
        public T run(Class<?> var1, DependencyInjectionRealm var2);
    }
}

