/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.services;

import fi.testee.deployment.EjbDescriptorImpl;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.services.EjbInjectionServicesImpl;
import fi.testee.utils.MutableContainer;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbServicesImpl
implements EjbServices {
    private static final Logger LOG = LoggerFactory.getLogger(EjbServicesImpl.class);
    private final EjbInjectionServicesImpl.EjbFactory beanFactory;

    public EjbServicesImpl(EjbInjectionServicesImpl.EjbFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public SessionObjectReference resolveEjb(EjbDescriptor<?> ejbDescriptor) {
        final MutableContainer removed = new MutableContainer((Object)false);
        final ResourceReferenceFactory<?> reference = this.beanFactory.createInstance(ejbDescriptor);
        return new SessionObjectReference(){

            public <S> S getBusinessObject(Class<S> businessInterfaceType) {
                return (S)reference.createResource().getInstance();
            }

            public void remove() {
            }

            public boolean isRemoved() {
                return (Boolean)removed.getObject();
            }
        };
    }

    public void registerInterceptors(EjbDescriptor<?> ejbDescriptor, InterceptorBindings interceptorBindings) {
        LOG.debug("Registering interceptors {} on {}", (Object)interceptorBindings.getAllInterceptors(), (Object)ejbDescriptor.getBeanClass());
        if (!(ejbDescriptor instanceof EjbDescriptorImpl)) {
            throw new TestEEfiException("Expected " + EjbDescriptorImpl.class.getName() + ", but got " + ejbDescriptor);
        }
        ((EjbDescriptorImpl)ejbDescriptor).setInterceptorBindings(interceptorBindings);
    }

    public void cleanup() {
    }
}

