/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.services;

import fi.testee.exceptions.TestEEfiException;
import fi.testee.jpa.PersistenceUnitDiscovery;
import fi.testee.utils.ProxyUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaInjectionServicesImpl
implements JpaInjectionServices {
    private static final Logger LOG = LoggerFactory.getLogger(JpaInjectionServicesImpl.class);
    public static final Supplier<RuntimeException> NOT_SUPPORTED = () -> new UnsupportedOperationException("This is not implemented, yet");
    private PersistenceUnitDiscovery persistenceUnitDiscovery;
    private Map<String, EntityManager> entityManagers = new HashMap<String, EntityManager>();

    public JpaInjectionServicesImpl(PersistenceUnitDiscovery persistenceUnitDiscovery) {
        this.persistenceUnitDiscovery = persistenceUnitDiscovery;
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceContext persistenceContext = (PersistenceContext)injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class);
        String unitName = persistenceContext.unitName();
        return this.registerPersistenceContextInjectionPoint(unitName);
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(String unitName) {
        LOG.debug("Creating persistence context for unit '{}'", (Object)unitName);
        PersistenceUnitInfo unit = this.persistenceUnitDiscovery.findByUnitName(unitName);
        if (unit == null) {
            throw new IllegalStateException("Unknown persistence unit: " + unitName);
        }
        EntityManager entityManager = (EntityManager)ProxyUtils.lazy(() -> this.getEntityManager(unit), EntityManager.class);
        return () -> new SimpleResourceReference((Object)this.safeguard(entityManager));
    }

    private EntityManager safeguard(EntityManager entityManager) {
        return (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (proxy, method, args) -> {
            try {
                if ("close".equals(method.getName())) {
                    throw new TestEEfiException("Naughty developer. One does not simply close the entity manager.");
                }
                if ("getTransaction".equals(method.getName())) {
                    throw new TestEEfiException("Naughty developer. One does not simply access the transaction.");
                }
                return method.invoke((Object)entityManager, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
    }

    private synchronized EntityManager getEntityManager(PersistenceUnitInfo unit) {
        if (this.entityManagers.containsKey(unit.getPersistenceUnitName())) {
            return this.entityManagers.get(unit.getPersistenceUnitName());
        }
        String providerClassName = unit.getPersistenceProviderClassName();
        try {
            PersistenceProvider provider = (PersistenceProvider)Class.forName(providerClassName).newInstance();
            EntityManagerFactory emf = provider.createContainerEntityManagerFactory(unit, new HashMap());
            EntityManager entityManager = emf.createEntityManager();
            this.entityManagers.put(unit.getPersistenceUnitName(), entityManager);
            entityManager.getTransaction().begin();
            return entityManager;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new TestEEfiException("Failed to load persistence provider class " + providerClassName, (Throwable)e);
        }
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        throw NOT_SUPPORTED.get();
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        throw NOT_SUPPORTED.get();
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        throw NOT_SUPPORTED.get();
    }

    public void cleanup() {
        this.entityManagers.values().forEach(it -> {
            if (it.isOpen()) {
                it.close();
            }
        });
    }

    public void flush() {
        LOG.debug("Flushing EntityManagers");
        this.entityManagers.values().forEach(it -> {
            if (it.isOpen() && it.getTransaction().isActive()) {
                it.flush();
            }
        });
    }

    public EntityManager resolvePersistenceContext(PersistenceContext persistenceContext) {
        return (EntityManager)this.registerPersistenceContextInjectionPoint(persistenceContext.unitName()).createResource().getInstance();
    }
}

