/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.services;

import fi.testee.spi.ResourceProvider;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;

public class ResourceInjectionServicesImpl
implements ResourceInjectionServices {
    private final Collection<ResourceProvider> providers;

    public ResourceInjectionServicesImpl(Collection<ResourceProvider> providers) {
        this.providers = providers;
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(InjectionPoint injectionPoint) {
        return this.registerInjectionPoint(o -> o.resolve(injectionPoint), injectionPoint.toString());
    }

    private ResourceReferenceFactory<Object> registerInjectionPoint(final Function<ResourceProvider, Object> resolver, final String description) {
        return () -> new SimpleResourceReference(ResourceInjectionServicesImpl.findResource(this.providers, new Function<ResourceProvider, Object>(){

            @Override
            public Object apply(ResourceProvider o) {
                return resolver.apply(o);
            }

            public String toString() {
                return description;
            }
        }));
    }

    private static Object findResource(Collection<ResourceProvider> providers, Function<ResourceProvider, Object> resolver) {
        Set candidates = providers.stream().map(resolver).filter(Objects::nonNull).collect(Collectors.toSet());
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Failed to resolve resource specification " + resolver);
        }
        if (candidates.size() > 1) {
            throw new IllegalStateException("Ambiguous resource specification" + resolver + ": " + candidates);
        }
        return candidates.iterator().next();
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(String jndiName, String mappedName) {
        return this.registerInjectionPoint(o -> o.resolve(jndiName, mappedName), "jndiName: " + jndiName + ", mappedName: " + mappedName);
    }

    public Object resolveResource(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object resolveResource(String s, String s1) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void cleanup() {
    }
}

