/*
 * Decompiled with CFR 0.152.
 */
package com.founder.core.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
public class RedisConfig
extends CachingConfigurerSupport {
    public KeyGenerator keyGenerator() {
        System.out.println("RedisCacheConfig.keyGenerator()");
        return new KeyGenerator(){

            public Object generate(Object o, Method method, Object ... objects) {
                StringBuilder sb = new StringBuilder();
                sb.append(o.getClass().getName());
                sb.append(method.getName());
                for (Object obj : objects) {
                    String key = String.valueOf(obj);
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    sb.append(key);
                }
                System.out.println("keyGenerator=" + sb.toString());
                return sb.toString();
            }
        };
    }

    @Configuration
    static class LocalConfiguration {
        @Value(value="${spring.redis.host}")
        private String host;
        @Value(value="${spring.redis.port}")
        private Integer port;
        @Value(value="${spring.redis.password}")
        private String password;
        @Value(value="${spring.redis.default.expiration:3600}")
        private long redisDefaultExpiration;

        LocalConfiguration() {
        }

        @Bean
        public RedisCacheManager cacheManager(RedisTemplate<?, ?> redisTemplate) {
            StringRedisSerializer redisSerializer = new StringRedisSerializer();
            Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
            ObjectMapper om = new ObjectMapper();
            om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
            om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
            jackson2JsonRedisSerializer.setObjectMapper(om);
            RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(this.redisDefaultExpiration)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer));
            RedisCacheManager cacheManager = RedisCacheManager.builder((RedisConnectionFactory)this.lettuceConnectionFactory()).cacheDefaults(config).build();
            return cacheManager;
        }

        @Bean
        public KeyGenerator keyGenerator() {
            return new SimpleKeyGenerator();
        }

        @Bean
        public RedisTemplate<String, Object> redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
            Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
            ObjectMapper om = new ObjectMapper();
            om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
            om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
            jackson2JsonRedisSerializer.setObjectMapper(om);
            RedisTemplate redisTemplate = new RedisTemplate();
            redisTemplate.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
            StringRedisSerializer stringSerializer = new StringRedisSerializer();
            redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
            redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
            redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
            redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
            redisTemplate.afterPropertiesSet();
            return redisTemplate;
        }

        @Bean
        public LettuceConnectionFactory lettuceConnectionFactory() {
            LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory();
            lettuceConnectionFactory.setHostName(this.host);
            lettuceConnectionFactory.setPort(this.port.intValue());
            lettuceConnectionFactory.setPassword(this.password);
            return lettuceConnectionFactory;
        }
    }
}

