/*
 * Decompiled with CFR 0.152.
 */
package foundation.cmo.opensales.weather.autoconfigure;

import foundation.cmo.opensales.weather.services.MWeatherService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={MWeatherProperty.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"cmo.foundation.weather.enable"}, havingValue="true", matchIfMissing=false)
public class MWeatherAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MWeatherAutoConfiguration.class);

    @Bean(value={"status-weather"})
    void status() {
        log.info("~> Module '{}' has been loaded.", (Object)"foundation.cmo.opensales.weather");
    }

    @Bean
    MWeatherService loadMWeatherService() {
        return new MWeatherService();
    }

    @ConfigurationProperties(value="cmo.foundation.weather")
    public class MWeatherProperty {
        private boolean enable;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MWeatherProperty)) {
                return false;
            }
            MWeatherProperty other = (MWeatherProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnable() == other.isEnable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MWeatherProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "MWeatherAutoConfiguration.MWeatherProperty(enable=" + this.isEnable() + ")";
        }
    }
}

