/*
 * Decompiled with CFR 0.152.
 */
package foundation.cmo.opensales.weather.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import foundation.cmo.opensales.weather.dto.MDistrict;
import foundation.cmo.opensales.weather.dto.MWeather;
import foundation.cmo.opensales.weather.dto.MWeatherLocation;
import io.leangen.graphql.annotations.GraphQLContext;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriUtils;

@Configuration
@EnableCaching
public class MWeatherService {
    @Value(value="${cmo.foundation.weather:http://api.openweathermap.org}")
    private String weatherUrl;
    @Value(value="${foundation.cmo.api.mls.geo.ibge-api-url:https://servicodados.ibge.gov.br}")
    private String ibgeUrl;
    @Value(value="${cmo.foundation.weather.apikey:f78e35a5edf2478e0569d6abe8a7dcdb}")
    private String apiKey;

    public String test() {
        return "MWeatherService running...";
    }

    public List<MWeatherLocation> findLocationByNameAndState(String locationName, String state) throws Exception {
        String sname = UriUtils.encode((String)locationName, (String)StandardCharsets.UTF_8.toString());
        String suri = String.format("%s/geo/1.0/direct?q=%s,%s,%s&limit=%d&appid=%s", this.weatherUrl, sname, state, "BR", 5, this.apiKey);
        URL uri = new URL(suri);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestProperty("accept", "application/json");
        InputStream responseStream = connection.getInputStream();
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.readValue(responseStream, (TypeReference)new TypeReference<List<MWeatherLocation>>(){});
    }

    public MWeather getMWeather(@GraphQLContext MWeatherLocation location) throws Exception {
        String suri = String.format("%s/data/3.0/onecall?lat=%s&lon=%s&units=metric&lang=pt_br&appid=%s", this.weatherUrl, location.getLatitude().toPlainString(), location.getLongitude().toPlainString(), this.apiKey);
        URL uri = new URL(suri);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestProperty("accept", "application/json");
        InputStream responseStream = connection.getInputStream();
        ObjectMapper mapper = new ObjectMapper();
        return (MWeather)mapper.readValue(responseStream, (TypeReference)new TypeReference<MWeather>(){});
    }

    @Cacheable(value={"ibge_district"})
    public MDistrict getDistrictFromIbge(Long ibgeId) throws Exception {
        String suri = String.format("%s/api/v1/localidades/distritos/%d", this.ibgeUrl, ibgeId);
        URL uri = new URL(suri);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestProperty("accept", "application/json");
        InputStream responseStream = connection.getInputStream();
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(responseStream, (TypeReference)new TypeReference<List<MDistrict>>(){});
        if (list.isEmpty()) {
            return null;
        }
        return (MDistrict)list.get(0);
    }
}

