/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml;

import java.util.Arrays;

public final class DocumentWriterConfig {
    public final String attrQuot;
    public final String prettyPrint;
    public final String indent;
    public final String attributeIndent;

    private DocumentWriterConfig(String attrQuot, String prettyPrint, String indent, String attributeIndent) {
        this.attrQuot = attrQuot;
        this.prettyPrint = prettyPrint;
        this.indent = indent;
        this.attributeIndent = attributeIndent;
    }

    public static DocumentWriterConfig config() {
        return new DocumentWriterConfig("\"", "", "", " ");
    }

    public DocumentWriterConfig singleQuoteValue() {
        return new DocumentWriterConfig("'", this.prettyPrint, this.indent, this.attributeIndent);
    }

    public DocumentWriterConfig doubleQuoteValue() {
        return new DocumentWriterConfig("\"", this.prettyPrint, this.indent, this.attributeIndent);
    }

    public DocumentWriterConfig indentSpaces(int level) {
        char[] indent = new char[level];
        Arrays.fill(indent, ' ');
        return new DocumentWriterConfig(this.attrQuot, "\n", new String(indent), this.attributeIndent);
    }

    public DocumentWriterConfig indentTabs(int level) {
        char[] indent = new char[level];
        Arrays.fill(indent, '\t');
        return new DocumentWriterConfig(this.attrQuot, "\n", new String(indent), this.attributeIndent);
    }

    public DocumentWriterConfig indentTabs() {
        return this.indentTabs(1);
    }

    public DocumentWriterConfig indentAttribute(int level) {
        return new DocumentWriterConfig(this.attrQuot, this.prettyPrint, this.indent, this.attributeIndent);
    }
}

