/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml.impl;

import foundation.fluent.api.xml.ContentWriter;
import foundation.fluent.api.xml.DocumentWriter;
import foundation.fluent.api.xml.DocumentWriterConfig;
import foundation.fluent.api.xml.ElementWriter;
import foundation.fluent.api.xml.writer.CDataWriter;
import foundation.fluent.api.xml.writer.EscapingWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;

public final class DocumentWriterImpl
implements DocumentWriter.XmlSpecWriter,
DocumentWriter.DoctypeWriter,
Supplier<ContentWriter> {
    private final DocumentWriterConfig config;
    private final PrintWriter writer;
    private final PrintWriter escapingWriter;
    private final PrintWriter cdataWriter;
    private ElementWriter child;
    private DocumentState state = DocumentState.EMPTY;

    public static DocumentWriter documentBuilder(Writer writer, DocumentWriterConfig config) {
        CDataWriter cdataWriter = new CDataWriter(writer);
        return new DocumentWriterImpl(config, new PrintWriter(writer), new PrintWriter(cdataWriter), new PrintWriter(new EscapingWriter(cdataWriter)));
    }

    private DocumentWriterImpl(DocumentWriterConfig config, PrintWriter writer, PrintWriter cdataWriter, PrintWriter escapingWriter) {
        this.config = config;
        this.writer = writer;
        this.cdataWriter = cdataWriter;
        this.escapingWriter = escapingWriter;
    }

    private DocumentWriter.XmlSpecWriter set(String name, String value) {
        switch (this.state) {
            case EMPTY: {
                this.writer.write("<?xml " + name + "=" + this.config.attrQuot + value + this.config.attrQuot);
                this.state = DocumentState.SPEC;
                break;
            }
            case SPEC: {
                this.writer.write(" " + name + "=" + this.config.attrQuot + value + this.config.attrQuot);
                break;
            }
            default: {
                throw new IllegalStateException("XML spec must be first in the document.");
            }
        }
        return this;
    }

    private void toContent() {
        switch (this.state) {
            case SPEC: {
                this.writer.write(63);
            }
            case DOCTYPE: {
                this.writer.write(62);
            }
            case EMPTY: {
                this.state = DocumentState.PREFIX;
            }
            case PREFIX: {
                return;
            }
            case OPEN: {
                this.child.end();
                this.state = DocumentState.FINISHED;
            }
        }
    }

    @Override
    public DocumentWriter.XmlSpecWriter version(String version) {
        return this.set("version", version);
    }

    @Override
    public DocumentWriter.DoctypeWriter doctype(String name) {
        switch (this.state) {
            case SPEC: {
                this.writer.write("?><!DOCTYPE " + name);
                break;
            }
            case EMPTY: 
            case PREFIX: {
                this.writer.write("<!DOCTYPE " + name);
                break;
            }
            default: {
                throw new IllegalStateException("DOCTYPE specification not allowed here.");
            }
        }
        this.state = DocumentState.DOCTYPE;
        return this;
    }

    @Override
    public DocumentWriter.DoctypeWriter publicDtd(String uri, String dtd) {
        if (this.state != DocumentState.DOCTYPE) {
            throw new IllegalStateException("Not in DOCTYPE definition.");
        }
        this.writer.write(" PUBLIC " + this.config.attrQuot);
        this.escapingWriter.write(uri);
        this.writer.write(this.config.attrQuot + ' ' + this.config.attrQuot);
        this.escapingWriter.write(dtd);
        this.writer.write(this.config.attrQuot);
        return this;
    }

    @Override
    public DocumentWriter.DoctypeWriter systemDtd(String dtd) {
        if (this.state != DocumentState.DOCTYPE) {
            throw new IllegalStateException("Not in DOCTYPE definition.");
        }
        this.writer.write(" SYSTEM " + this.config.attrQuot);
        this.escapingWriter.write(dtd);
        this.writer.write(this.config.attrQuot);
        return this;
    }

    @Override
    public DocumentWriter flush() {
        this.writer.flush();
        return this;
    }

    @Override
    public DocumentWriter.XmlSpecWriter encoding(String encoding) {
        return this.set("encoding", encoding);
    }

    @Override
    public DocumentWriter instruction(String name, String content) {
        this.toContent();
        this.writer.write(this.config.prettyPrint + "<?" + name + " " + content + "?>");
        return this;
    }

    @Override
    public ElementWriter tag(String tag) {
        switch (this.state) {
            case EMPTY: {
                this.writer.write('<' + tag);
                break;
            }
            case SPEC: {
                this.writer.write("?>" + this.config.prettyPrint + '<' + tag);
                break;
            }
            case DOCTYPE: {
                this.writer.write(">" + this.config.prettyPrint + '<' + tag);
                break;
            }
            case PREFIX: {
                this.writer.write(this.config.prettyPrint + '<' + tag);
                break;
            }
            default: {
                throw new IllegalStateException("Trying to output second root.");
            }
        }
        this.state = DocumentState.OPEN;
        this.child = new ElementWriterImpl(this.config.prettyPrint, tag, this);
        return this.child;
    }

    @Override
    public ElementWriter tag(String nsPrefix, String tag) {
        return this.tag(nsPrefix + ':' + tag);
    }

    @Override
    public ContentWriter text(String content) {
        if (Objects.isNull(content)) {
            return this;
        }
        for (int i = 0; i < content.length(); ++i) {
            if (Character.isWhitespace(content.charAt(i))) continue;
            throw new IllegalStateException("Cannot write text out of the root element.");
        }
        switch (this.state) {
            case SPEC: {
                this.writer.write("?>" + content);
                this.state = DocumentState.PREFIX;
                break;
            }
            case DOCTYPE: {
                this.writer.write(">" + content);
                this.state = DocumentState.PREFIX;
                break;
            }
            case OPEN: {
                this.child.end();
                this.writer.write(content);
                this.state = DocumentState.FINISHED;
            }
        }
        return this;
    }

    @Override
    public ContentWriter cdata(String content) {
        throw new IllegalStateException("Cannot write CDATA out of the root element.");
    }

    @Override
    public ContentWriter comment(String comment) {
        this.toContent();
        this.cdataWriter.write(this.config.prettyPrint + "<!-- " + comment + " -->");
        return this;
    }

    @Override
    public ContentWriter end() {
        throw new IllegalStateException("No open element to close.");
    }

    @Override
    public void close() {
        switch (this.state) {
            default: {
                throw new IllegalStateException("No root element created.");
            }
            case OPEN: {
                this.child.end();
                this.state = DocumentState.FINISHED;
            }
            case FINISHED: 
        }
        this.escapingWriter.close();
    }

    @Override
    public ContentWriter get() {
        this.child = null;
        this.state = DocumentState.FINISHED;
        return this;
    }

    private final class ElementWriterImpl
    implements ElementWriter,
    Supplier<ContentWriter> {
        private final String tagPrefix;
        private final String prefix;
        private final String tag;
        private final Supplier<ContentWriter> parent;
        private ElementWriter child;
        private ElementState state = ElementState.OPENING;

        private ElementWriterImpl(String prefix, String tag, Supplier<ContentWriter> parent) {
            this.tagPrefix = prefix;
            this.prefix = prefix + ((DocumentWriterImpl)DocumentWriterImpl.this).config.indent;
            this.tag = tag;
            this.parent = parent;
        }

        @Override
        public ElementWriter xmlns(String name) {
            return this.attribute("xmlns", name);
        }

        @Override
        public ElementWriter xmlns(String prefix, URI uri) {
            return this.attribute("xmlns:" + prefix, String.valueOf(uri));
        }

        @Override
        public ElementWriter attribute(String name, String value) {
            if (this.state == ElementState.OPENING) {
                DocumentWriterImpl.this.writer.write(((DocumentWriterImpl)DocumentWriterImpl.this).config.attributeIndent + name + "=" + ((DocumentWriterImpl)DocumentWriterImpl.this).config.attrQuot);
                DocumentWriterImpl.this.escapingWriter.write(value);
                DocumentWriterImpl.this.writer.write(((DocumentWriterImpl)DocumentWriterImpl.this).config.attrQuot);
                return this;
            }
            throw new IllegalStateException("Cannot write attribute " + name + "='" + value + "', when tag <" + this.tag + "> content started.");
        }

        @Override
        public ElementWriter flush() {
            DocumentWriterImpl.this.writer.flush();
            return this;
        }

        @Override
        public ContentWriter instruction(String name, String content) {
            this.toContent();
            DocumentWriterImpl.this.writer.write(this.prefix + "<?" + name + " " + content + "?>");
            return this;
        }

        @Override
        public ElementWriter tag(String tag) {
            this.toContent();
            DocumentWriterImpl.this.writer.write(this.prefix + '<' + tag);
            this.child = new ElementWriterImpl(this.prefix, tag, this);
            return this.child;
        }

        @Override
        public ElementWriter tag(String nsPrefix, String tag) {
            return this.tag(nsPrefix + ':' + tag);
        }

        @Override
        public ContentWriter text(String content) {
            this.toContent();
            DocumentWriterImpl.this.escapingWriter.write(this.prefix + content);
            return this;
        }

        @Override
        public ContentWriter cdata(String content) {
            switch (this.state) {
                case OPENING: {
                    DocumentWriterImpl.this.writer.write("/>" + this.prefix + "<![CDATA[");
                    this.state = ElementState.CDATA;
                    break;
                }
                case CONTENT: {
                    this.closeChild();
                    DocumentWriterImpl.this.writer.write(this.prefix + "<![CDATA[");
                    this.state = ElementState.CDATA;
                    break;
                }
                case CLOSED: {
                    throw new IllegalStateException("Element " + this.tag + " already closed.");
                }
            }
            DocumentWriterImpl.this.cdataWriter.write(content);
            return this;
        }

        @Override
        public ContentWriter comment(String comment) {
            this.toContent();
            DocumentWriterImpl.this.cdataWriter.write(this.prefix + "<!-- " + comment + " -->");
            return this;
        }

        @Override
        public ContentWriter end() {
            switch (this.state) {
                case OPENING: {
                    DocumentWriterImpl.this.writer.write("/>");
                    break;
                }
                case CONTENT: {
                    this.closeChild();
                    DocumentWriterImpl.this.writer.write(this.tagPrefix + "</" + this.tag + '>');
                    break;
                }
                case CDATA: {
                    DocumentWriterImpl.this.writer.write("]]>" + this.tagPrefix + "</" + this.tag + '>');
                    break;
                }
                case CLOSED: {
                    throw new IllegalStateException("Element " + this.tag + " already closed.");
                }
            }
            this.state = ElementState.CLOSED;
            return this.parent.get();
        }

        @Override
        public void close() {
            this.end().close();
        }

        private void closeChild() {
            if (Objects.nonNull(this.child)) {
                this.child.end();
            }
        }

        private void toContent() {
            switch (this.state) {
                case OPENING: {
                    DocumentWriterImpl.this.writer.write(">");
                    break;
                }
                case CDATA: {
                    DocumentWriterImpl.this.writer.write("]]>");
                    break;
                }
                case CONTENT: {
                    this.closeChild();
                    break;
                }
                case CLOSED: {
                    throw new IllegalStateException("Element " + this.tag + " already closed.");
                }
            }
            this.state = ElementState.CONTENT;
        }

        @Override
        public ContentWriter get() {
            this.child = null;
            return this;
        }
    }

    static enum ElementState {
        OPENING,
        CONTENT,
        CDATA,
        CLOSED;

    }

    static enum DocumentState {
        EMPTY,
        SPEC,
        DOCTYPE,
        PREFIX,
        OPEN,
        FINISHED;

    }
}

