/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx;

import foundation.icon.icx.Call;
import foundation.icon.icx.Provider;
import foundation.icon.icx.Request;
import foundation.icon.icx.SignedTransaction;
import foundation.icon.icx.Transaction;
import foundation.icon.icx.crypto.IconKeys;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Block;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.ConfirmedTransaction;
import foundation.icon.icx.data.Converters;
import foundation.icon.icx.data.ScoreApi;
import foundation.icon.icx.data.TransactionResult;
import foundation.icon.icx.transport.jsonrpc.AnnotatedConverterFactory;
import foundation.icon.icx.transport.jsonrpc.AnnotationConverter;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IconService {
    private Provider provider;
    private List<RpcConverter.RpcConverterFactory> converterFactories = new ArrayList<RpcConverter.RpcConverterFactory>();
    private Map<Class, RpcConverter<?>> converterMap = new HashMap();

    public IconService(Provider provider) {
        this.provider = provider;
        this.addConverterFactory(Converters.newFactory(BigInteger.class, Converters.BIG_INTEGER));
        this.addConverterFactory(Converters.newFactory(Boolean.class, Converters.BOOLEAN));
        this.addConverterFactory(Converters.newFactory(String.class, Converters.STRING));
        this.addConverterFactory(Converters.newFactory(Bytes.class, Converters.BYTES));
        this.addConverterFactory(Converters.newFactory(byte[].class, Converters.BYTE_ARRAY));
        this.addConverterFactory(Converters.newFactory(Block.class, Converters.BLOCK));
        this.addConverterFactory(Converters.newFactory(ConfirmedTransaction.class, Converters.CONFIRMED_TRANSACTION));
        this.addConverterFactory(Converters.newFactory(TransactionResult.class, Converters.TRANSACTION_RESULT));
        Class<List> listClass = List.class;
        this.addConverterFactory(Converters.newFactory(listClass, Converters.SCORE_API_LIST));
        this.addConverterFactory(Converters.newFactory(RpcItem.class, Converters.RPC_ITEM));
    }

    public Request<BigInteger> getTotalSupply() {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getTotalSupply", null);
        return this.provider.request(request, this.findConverter(BigInteger.class));
    }

    public Request<BigInteger> getBalance(Address address) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("address", new RpcValue(address)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBalance", params);
        return this.provider.request(request, this.findConverter(BigInteger.class));
    }

    public Request<Block> getBlock(BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBlockByHeight", params);
        return this.provider.request(request, this.findConverter(Block.class));
    }

    public Request<Block> getBlock(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("hash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBlockByHash", params);
        return this.provider.request(request, this.findConverter(Block.class));
    }

    public Request<Block> getLastBlock() {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getLastBlock", null);
        return this.provider.request(request, this.findConverter(Block.class));
    }

    public Request<List<ScoreApi>> getScoreApi(Address scoreAddress) {
        if (!IconKeys.isContractAddress(scoreAddress)) {
            throw new IllegalArgumentException("Only the contract address can be called.");
        }
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("address", new RpcValue(scoreAddress)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getScoreApi", params);
        Class<List> listClass = List.class;
        return this.provider.request(request, this.findConverter(listClass));
    }

    public Request<ConfirmedTransaction> getTransaction(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("txHash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getTransactionByHash", params);
        return this.provider.request(request, this.findConverter(ConfirmedTransaction.class));
    }

    public Request<TransactionResult> getTransactionResult(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("txHash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getTransactionResult", params);
        return this.provider.request(request, this.findConverter(TransactionResult.class));
    }

    public <T> Request<T> call(Call<T> call) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_call", call.getProperties());
        return this.provider.request(request, this.findConverter(call.responseType()));
    }

    public Request<Bytes> sendTransaction(SignedTransaction signedTransaction) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_sendTransaction", signedTransaction.getProperties());
        return this.provider.request(request, this.findConverter(Bytes.class));
    }

    public Request<BigInteger> estimateStep(Transaction transaction) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "debug_estimateStep", transaction.getProperties());
        return this.provider.request(request, this.findConverter(BigInteger.class));
    }

    private <T> RpcConverter<T> findConverter(Class<T> type) {
        RpcConverter<Object> converter = this.converterMap.get(type);
        if (converter != null) {
            return converter;
        }
        for (RpcConverter.RpcConverterFactory factory : this.converterFactories) {
            converter = factory.create(type);
            if (converter == null) continue;
            this.converterMap.put(type, converter);
            return converter;
        }
        if (type.isAnnotationPresent(AnnotationConverter.class) && type.getAnnotation(AnnotationConverter.class).use()) {
            return new AnnotatedConverterFactory().create(type);
        }
        throw new IllegalArgumentException("Could not locate response converter for:'" + type + "'");
    }

    public void addConverterFactory(RpcConverter.RpcConverterFactory factory) {
        this.converterFactories.add(factory);
    }
}

