/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx;

import foundation.icon.icx.Transaction;
import foundation.icon.icx.TransactionBuilder;
import foundation.icon.icx.Wallet;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.TreeSet;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import org.bouncycastle.util.encoders.Base64;

public class SignedTransaction {
    private Transaction transaction;
    private Wallet wallet;
    private RpcObject properties;

    public SignedTransaction(Transaction transaction, Wallet wallet) {
        TransactionBuilder.checkArgument(transaction.getStepLimit(), "stepLimit not found");
        this.transaction = transaction;
        this.wallet = wallet;
        this.createProperties(null);
    }

    public SignedTransaction(Transaction transaction, Wallet wallet, BigInteger stepLimit) {
        this.transaction = transaction;
        this.wallet = wallet;
        this.createProperties(stepLimit);
    }

    private void createProperties(BigInteger stepLimit) {
        RpcObject.Builder builder = new RpcObject.Builder();
        if (stepLimit != null) {
            builder.put("stepLimit", new RpcValue(stepLimit));
        }
        RpcObject object = this.getTransactionProperties();
        for (String key : object.keySet()) {
            builder.put(key, object.getItem(key));
        }
        String signature = Base64.toBase64String((byte[])this.getSignature(builder.build()));
        builder.put("signature", new RpcValue(signature));
        this.properties = builder.build();
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    RpcObject getTransactionProperties() {
        return this.transaction.getProperties();
    }

    private byte[] getSignature(RpcObject properties) {
        return this.wallet.sign(this.generateMessage(this.serialize(properties)));
    }

    private byte[] generateMessage(String data) {
        return new SHA3.Digest256().digest(data.getBytes(StandardCharsets.UTF_8));
    }

    String serialize(RpcObject properties) {
        return TransactionSerializer.serialize(properties);
    }

    public static class TransactionSerializer {
        public static String serialize(RpcObject properties) {
            StringBuilder builder = new StringBuilder();
            builder.append("icx_sendTransaction.");
            TransactionSerializer.serializeObjectItems(builder, properties);
            return builder.toString();
        }

        static void serialize(StringBuilder builder, RpcItem item) {
            if (item instanceof RpcObject) {
                builder.append("{");
                TransactionSerializer.serializeObjectItems(builder, item.asObject());
                builder.append("}");
            } else if (item instanceof RpcArray) {
                builder.append("[");
                TransactionSerializer.serializeArrayItems(builder, item.asArray());
                builder.append("]");
            } else if (item == null) {
                builder.append("\\0");
            } else {
                builder.append(TransactionSerializer.escape(item.asString()));
            }
        }

        private static void serializeObjectItems(StringBuilder builder, RpcObject object) {
            boolean firstItem = true;
            TreeSet<String> keys = new TreeSet<String>(object.keySet());
            for (String key : keys) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(".");
                }
                TransactionSerializer.serialize(builder.append(key).append("."), object.getItem(key));
            }
        }

        private static void serializeArrayItems(StringBuilder builder, RpcArray array) {
            boolean firstItem = true;
            for (RpcItem child : array) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(".");
                }
                TransactionSerializer.serialize(builder, child);
            }
        }

        static String escape(String string) {
            return string.replaceAll("([\\\\.{}\\[\\]])", "\\\\$1");
        }
    }
}

