/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx;

import foundation.icon.icx.Transaction;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.NetworkId;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemCreator;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public final class TransactionBuilder {
    public static Builder of(NetworkId nid) {
        Builder builder = TransactionBuilder.newBuilder();
        return builder.nid(nid.getValue());
    }

    public static Builder of(BigInteger nid) {
        Builder builder = TransactionBuilder.newBuilder();
        return builder.nid(nid);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static <T> void checkArgument(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static class RawTransaction
    implements Transaction {
        private BigInteger version;
        private Address from;
        private Address to;
        private BigInteger value;
        private BigInteger stepLimit;
        private BigInteger timestamp;
        private BigInteger nid;
        private BigInteger nonce;
        private String dataType;
        private RpcItem data;

        private RawTransaction(TransactionData transactionData) {
            this.version = transactionData.version;
            this.from = transactionData.from;
            this.to = transactionData.to;
            this.value = transactionData.value;
            this.stepLimit = transactionData.stepLimit;
            this.timestamp = transactionData.timestamp;
            this.nid = transactionData.nid;
            this.nonce = transactionData.nonce;
            this.dataType = transactionData.dataType;
            this.data = transactionData.data;
        }

        @Override
        public BigInteger getVersion() {
            return this.version;
        }

        @Override
        public Address getFrom() {
            return this.from;
        }

        @Override
        public Address getTo() {
            return this.to;
        }

        @Override
        public BigInteger getValue() {
            return this.value;
        }

        @Override
        public BigInteger getStepLimit() {
            return this.stepLimit;
        }

        @Override
        public BigInteger getTimestamp() {
            return this.timestamp;
        }

        @Override
        public BigInteger getNid() {
            return this.nid;
        }

        @Override
        public BigInteger getNonce() {
            return this.nonce;
        }

        @Override
        public String getDataType() {
            return this.dataType;
        }

        @Override
        public RpcItem getData() {
            return this.data;
        }

        @Override
        public RpcObject getProperties() {
            if (this.timestamp == null) {
                this.timestamp = new BigInteger(Long.toString(System.currentTimeMillis() * 1000L));
            }
            RpcObject.Builder builder = new RpcObject.Builder();
            this.putPropertyToBuilder(builder, "version", this.getVersion());
            this.putPropertyToBuilder(builder, "from", this.getFrom());
            this.putPropertyToBuilder(builder, "to", this.getTo());
            this.putPropertyToBuilder(builder, "value", this.getValue());
            this.putPropertyToBuilder(builder, "stepLimit", this.getStepLimit());
            this.putPropertyToBuilder(builder, "timestamp", this.timestamp);
            this.putPropertyToBuilder(builder, "nid", this.getNid());
            this.putPropertyToBuilder(builder, "nonce", this.getNonce());
            this.putPropertyToBuilder(builder, "dataType", this.getDataType());
            this.putPropertyToBuilder(builder, "data", this.getData());
            return builder.build();
        }

        private void putPropertyToBuilder(RpcObject.Builder builder, String key, Object value) {
            if (value != null) {
                if (value instanceof BigInteger) {
                    builder.put(key, new RpcValue((BigInteger)value));
                } else if (value instanceof Address) {
                    builder.put(key, new RpcValue((Address)value));
                } else if (value instanceof String) {
                    builder.put(key, new RpcValue((String)value));
                } else if (value instanceof RpcItem) {
                    builder.put(key, (RpcItem)value);
                }
            }
        }
    }

    private static class TransactionData {
        private BigInteger version = new BigInteger("3");
        private Address from;
        private Address to;
        private BigInteger value;
        private BigInteger stepLimit;
        private BigInteger timestamp;
        private BigInteger nid = NetworkId.MAIN.getValue();
        private BigInteger nonce;
        private String dataType;
        private RpcItem data;

        private TransactionData() {
        }

        private Transaction build() {
            this.checkAddress(this.from, "from not found");
            this.checkAddress(this.to, "to not found");
            TransactionBuilder.checkArgument(this.version, "version not found");
            return new RawTransaction(this);
        }

        void checkAddress(Address address, String message) {
            TransactionBuilder.checkArgument(address, message);
            if (address.isMalformed()) {
                throw new IllegalArgumentException("Invalid address");
            }
        }
    }

    public static final class DepositBuilder {
        private TransactionData transactionData;
        private RpcObject.Builder dataBuilder;

        private DepositBuilder(TransactionData transactionData) {
            this.transactionData = transactionData;
            this.transactionData.dataType = "deposit";
        }

        public DepositBuilder add() {
            if (this.dataBuilder != null) {
                throw new IllegalArgumentException("action already defined");
            }
            this.dataBuilder = new RpcObject.Builder().put("action", new RpcValue("add"));
            return this;
        }

        public DepositBuilder withdraw(Bytes id) {
            if (this.dataBuilder != null) {
                throw new IllegalArgumentException("action already defined");
            }
            this.dataBuilder = new RpcObject.Builder().put("action", new RpcValue("withdraw")).put("id", new RpcValue(id));
            return this;
        }

        public Transaction build() {
            TransactionBuilder.checkArgument(this.dataBuilder, "action not found");
            this.transactionData.data = this.dataBuilder.build();
            return this.transactionData.build();
        }
    }

    public static final class DeployBuilder {
        private TransactionData transactionData;
        private RpcObject.Builder dataBuilder;

        private DeployBuilder(TransactionData transactionData, String contentType, byte[] content) {
            this.transactionData = transactionData;
            this.transactionData.dataType = "deploy";
            this.dataBuilder = new RpcObject.Builder().put("contentType", new RpcValue(contentType)).put("content", new RpcValue(content));
        }

        public DeployBuilder params(RpcObject params) {
            this.dataBuilder.put("params", params);
            return this;
        }

        public Transaction build() {
            this.transactionData.data = this.dataBuilder.build();
            TransactionBuilder.checkArgument(((RpcObject)this.transactionData.data).getItem("contentType"), "contentType not found");
            TransactionBuilder.checkArgument(((RpcObject)this.transactionData.data).getItem("content"), "content not found");
            return this.transactionData.build();
        }
    }

    public static final class MessageBuilder {
        private TransactionData transactionData;

        private MessageBuilder(TransactionData transactionData, String message) {
            this.transactionData = transactionData;
            this.transactionData.dataType = "message";
            this.transactionData.data = new RpcValue(message.getBytes(StandardCharsets.UTF_8));
        }

        public Transaction build() {
            return this.transactionData.build();
        }
    }

    public static final class CallBuilder {
        private TransactionData transactionData;
        private RpcObject.Builder dataBuilder;

        private CallBuilder(TransactionData transactionData, String method) {
            this.transactionData = transactionData;
            this.transactionData.dataType = "call";
            this.dataBuilder = new RpcObject.Builder().put("method", new RpcValue(method));
        }

        public CallBuilder params(RpcObject params) {
            this.dataBuilder.put("params", params);
            return this;
        }

        public <T> CallBuilder params(T params) {
            this.dataBuilder.put("params", RpcItemCreator.create(params));
            return this;
        }

        public Transaction build() {
            this.transactionData.data = this.dataBuilder.build();
            TransactionBuilder.checkArgument(((RpcObject)this.transactionData.data).getItem("method"), "method not found");
            return this.transactionData.build();
        }
    }

    public static final class Builder {
        private TransactionData transactionData = new TransactionData();

        private Builder() {
        }

        public Builder nid(BigInteger nid) {
            this.transactionData.nid = nid;
            return this;
        }

        public Builder nid(NetworkId nid) {
            this.transactionData.nid = nid.getValue();
            return this;
        }

        public Builder from(Address from) {
            this.transactionData.from = from;
            return this;
        }

        public Builder to(Address to) {
            this.transactionData.to = to;
            return this;
        }

        public Builder value(BigInteger value) {
            this.transactionData.value = value;
            return this;
        }

        public Builder stepLimit(BigInteger stepLimit) {
            this.transactionData.stepLimit = stepLimit;
            return this;
        }

        public Builder timestamp(BigInteger timestamp) {
            this.transactionData.timestamp = timestamp;
            return this;
        }

        public Builder nonce(BigInteger nonce) {
            this.transactionData.nonce = nonce;
            return this;
        }

        public CallBuilder call(String method) {
            return new CallBuilder(this.transactionData, method);
        }

        public DeployBuilder deploy(String contentType, byte[] content) {
            return new DeployBuilder(this.transactionData, contentType, content);
        }

        public MessageBuilder message(String message) {
            return new MessageBuilder(this.transactionData, message);
        }

        public DepositBuilder deposit() {
            return new DepositBuilder(this.transactionData);
        }

        public Transaction build() {
            return this.transactionData.build();
        }
    }
}

