/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.crypto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import foundation.icon.icx.crypto.Keystore;
import foundation.icon.icx.crypto.KeystoreException;
import foundation.icon.icx.crypto.KeystoreFile;
import foundation.icon.icx.data.Bytes;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.InputMismatchException;
import java.util.TimeZone;

public class KeyStoreUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private KeyStoreUtils() {
    }

    public static String generateWalletFile(KeystoreFile file, File destinationDirectory) throws IOException {
        String fileName = KeyStoreUtils.getWalletFileName(file);
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)file);
        return fileName;
    }

    public static Bytes loadPrivateKey(String password, File source) throws IOException, KeystoreException {
        ObjectMapper mapper = new ObjectMapper();
        KeystoreFile keystoreFile = (KeystoreFile)mapper.readValue(source, KeystoreFile.class);
        if (keystoreFile.getCoinType() == null || !keystoreFile.getCoinType().equalsIgnoreCase("icx")) {
            throw new InputMismatchException("Invalid Keystore file");
        }
        return Keystore.decrypt(password, keystoreFile);
    }

    private static String getWalletFileName(KeystoreFile keystoreFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("'UTC--'yyyy-MM-dd'T'HH-mm-ss.SSS'--'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date()) + keystoreFile.getAddress() + ".json";
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

