/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class Bytes {
    public static final String HEX_PREFIX = "0x";
    private byte[] data;

    public Bytes(String hexString) {
        if (!this.isValidHex(hexString)) {
            throw new IllegalArgumentException("The value is not hex string.");
        }
        this.data = Hex.decode((String)Bytes.cleanHexPrefix(hexString));
    }

    public Bytes(byte[] data) {
        this.data = data;
    }

    public Bytes(BigInteger value) {
        this.data = value.toByteArray();
    }

    public byte[] toByteArray() {
        return this.data;
    }

    @Deprecated
    private static byte[] toBytesPadded(BigInteger value, int length) {
        return Bytes.toBytesPadded(value.toByteArray(), length);
    }

    public static byte[] toBytesPadded(byte[] value, int length) {
        byte[] result = new byte[length];
        int bytesLength = value.length;
        int srcOffset = 0;
        if (bytesLength > length) {
            throw new IllegalArgumentException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(value, srcOffset, result, destOffset, bytesLength);
        return result;
    }

    public static String cleanHexPrefix(String input) {
        if (Bytes.containsHexPrefix(input)) {
            return input.substring(2);
        }
        return input;
    }

    public String toHexString(boolean withPrefix) {
        return this.toHexString(withPrefix, this.data.length);
    }

    public static boolean containsHexPrefix(String input) {
        return input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }

    public byte[] toByteArray(int size) {
        return Bytes.toBytesPadded(this.data, size);
    }

    public String toString() {
        return this.toHexString(true, this.data.length);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Bytes) {
            return Arrays.equals(((Bytes)obj).data, this.data);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toHexString(boolean withPrefix, int size) {
        String result = Hex.toHexString((byte[])this.data);
        int length = result.length();
        if (length < size) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size - length; ++i) {
                sb.append('0');
            }
            result = sb.append(result).toString();
        }
        if (withPrefix) {
            return HEX_PREFIX + result;
        }
        return result;
    }

    public int length() {
        return this.data == null ? 0 : this.data.length;
    }

    private boolean isValidHex(String value) {
        String v = Bytes.cleanHexPrefix(value);
        return v.matches("^[0-9a-fA-F]+$");
    }
}

