/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Block;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.ConfirmedTransaction;
import foundation.icon.icx.data.ScoreApi;
import foundation.icon.icx.data.TransactionResult;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemCreator;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class Converters {
    public static final RpcConverter<RpcItem> RPC_ITEM = new RpcConverter<RpcItem>(){

        @Override
        public RpcItem convertTo(RpcItem object) {
            return object;
        }

        @Override
        public RpcItem convertFrom(RpcItem object) {
            return object;
        }
    };
    public static final RpcConverter<BigInteger> BIG_INTEGER = new RpcConverter<BigInteger>(){

        @Override
        public BigInteger convertTo(RpcItem object) {
            return object.asInteger();
        }

        @Override
        public RpcItem convertFrom(BigInteger object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<Boolean> BOOLEAN = new RpcConverter<Boolean>(){

        @Override
        public Boolean convertTo(RpcItem object) {
            return object.asBoolean();
        }

        @Override
        public RpcItem convertFrom(Boolean object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<String> STRING = new RpcConverter<String>(){

        @Override
        public String convertTo(RpcItem object) {
            return object.asString();
        }

        @Override
        public RpcItem convertFrom(String object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<Bytes> BYTES = new RpcConverter<Bytes>(){

        @Override
        public Bytes convertTo(RpcItem object) {
            return object.asBytes();
        }

        @Override
        public RpcItem convertFrom(Bytes object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<byte[]> BYTE_ARRAY = new RpcConverter<byte[]>(){

        @Override
        public byte[] convertTo(RpcItem object) {
            return object.asByteArray();
        }

        @Override
        public RpcItem convertFrom(byte[] object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<Block> BLOCK = new RpcConverter<Block>(){

        @Override
        public Block convertTo(RpcItem object) {
            return new Block(object.asObject());
        }

        @Override
        public RpcItem convertFrom(Block object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<ConfirmedTransaction> CONFIRMED_TRANSACTION = new RpcConverter<ConfirmedTransaction>(){

        @Override
        public ConfirmedTransaction convertTo(RpcItem object) {
            return new ConfirmedTransaction(object.asObject());
        }

        @Override
        public RpcItem convertFrom(ConfirmedTransaction object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<TransactionResult> TRANSACTION_RESULT = new RpcConverter<TransactionResult>(){

        @Override
        public TransactionResult convertTo(RpcItem object) {
            return new TransactionResult(object.asObject());
        }

        @Override
        public RpcItem convertFrom(TransactionResult object) {
            return RpcItemCreator.create(object);
        }
    };
    public static final RpcConverter<List<ScoreApi>> SCORE_API_LIST = new RpcConverter<List<ScoreApi>>(){

        @Override
        public List<ScoreApi> convertTo(RpcItem rpcItem) {
            RpcArray array = rpcItem.asArray();
            ArrayList<ScoreApi> scoreApis = new ArrayList<ScoreApi>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                scoreApis.add(new ScoreApi(array.get(i).asObject()));
            }
            return scoreApis;
        }

        @Override
        public RpcItem convertFrom(List<ScoreApi> object) {
            return RpcItemCreator.create(object);
        }
    };

    private Converters() {
    }

    public static <TT> RpcConverter.RpcConverterFactory newFactory(final Class<TT> typeFor, final RpcConverter<TT> converter) {
        return new RpcConverter.RpcConverterFactory(){

            @Override
            public <T> RpcConverter<T> create(Class<T> type) {
                return type.isAssignableFrom(typeFor) ? converter : null;
            }
        };
    }

    public static <T> Object fromRpcItem(T item, Class<?> type) {
        if (item == null) {
            return null;
        }
        if (item.getClass().isAssignableFrom(RpcArray.class)) {
            return Converters.fromRpcArray((RpcArray)item, type);
        }
        if (item.getClass().isAssignableFrom(RpcObject.class)) {
            return Converters.fromRpcObject((RpcObject)item, type);
        }
        return Converters.fromRpcValue((RpcValue)item, type);
    }

    static <T> Object fromRpcArray(RpcArray array, Class<T> type) {
        if (type.isAssignableFrom(RpcArray.class)) {
            return array;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (RpcItem item : array) {
            Object v = Converters.fromRpcItem(item, type);
            if (v == null) continue;
            result.add(Converters.fromRpcItem(item, type));
        }
        return result;
    }

    static <T> Object fromRpcObject(RpcObject object, Class<T> type) {
        if (type.isAssignableFrom(RpcObject.class)) {
            return object;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<String> keys = object.keySet();
        for (String key : keys) {
            Object v = Converters.fromRpcItem(object.getItem(key), type);
            if (v == null) continue;
            result.put(key, v);
        }
        return result;
    }

    static <T> Object fromRpcValue(RpcValue value, Class<T> type) {
        if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            return value.asBoolean();
        }
        if (type.isAssignableFrom(String.class)) {
            return value.asString();
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return value.asInteger();
        }
        if (type.isAssignableFrom(byte[].class)) {
            return value.asByteArray();
        }
        if (type.isAssignableFrom(Bytes.class)) {
            return value.asBytes();
        }
        if (type.isAssignableFrom(Address.class)) {
            return value.asAddress();
        }
        if (type.isAssignableFrom(RpcItem.class)) {
            return value;
        }
        return null;
    }
}

