/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TransactionResult {
    private RpcObject properties;

    TransactionResult(RpcObject properties) {
        this.properties = properties;
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    public BigInteger getStatus() {
        RpcItem status = this.properties.getItem("status");
        if (status != null) {
            return status.asInteger();
        }
        RpcItem code = this.properties.getItem("code");
        if (code != null) {
            return new BigInteger(code.asInteger().intValue() == 0 ? "1" : "0");
        }
        return null;
    }

    public String getTo() {
        RpcItem item = this.properties.getItem("to");
        return item != null ? item.asString() : null;
    }

    public Bytes getTxHash() {
        RpcItem item = this.properties.getItem("txHash");
        return item != null ? item.asBytes() : null;
    }

    public BigInteger getTxIndex() {
        RpcItem item = this.properties.getItem("txIndex");
        return item != null ? item.asInteger() : null;
    }

    public BigInteger getBlockHeight() {
        RpcItem item = this.properties.getItem("blockHeight");
        return item != null ? item.asInteger() : null;
    }

    public Bytes getBlockHash() {
        RpcItem item = this.properties.getItem("blockHash");
        return item != null ? item.asBytes() : null;
    }

    public BigInteger getCumulativeStepUsed() {
        RpcItem item = this.properties.getItem("cumulativeStepUsed");
        return item != null ? item.asInteger() : null;
    }

    public BigInteger getStepUsed() {
        RpcItem item = this.properties.getItem("stepUsed");
        return item != null ? item.asInteger() : null;
    }

    public RpcItem getStepUsedDetails() {
        return this.properties.getItem("stepUsedDetails");
    }

    public BigInteger getStepPrice() {
        RpcItem item = this.properties.getItem("stepPrice");
        return item != null ? item.asInteger() : null;
    }

    public String getScoreAddress() {
        RpcItem item = this.properties.getItem("scoreAddress");
        return item != null ? item.asString() : null;
    }

    public String getLogsBloom() {
        RpcItem item = this.properties.getItem("logsBloom");
        return item != null ? item.asString() : null;
    }

    public List<EventLog> getEventLogs() {
        RpcItem item = this.properties.getItem("eventLogs");
        ArrayList<EventLog> eventLogs = new ArrayList<EventLog>();
        if (item != null) {
            for (RpcItem rpcItem : item.asArray()) {
                eventLogs.add(new EventLog(rpcItem.asObject()));
            }
        }
        return eventLogs;
    }

    public Failure getFailure() {
        RpcItem code;
        BigInteger status;
        RpcItem failure = this.properties.getItem("failure");
        if (failure == null && (status = this.getStatus()) != null && status.intValue() == 0 && (code = this.properties.getItem("code")) != null) {
            RpcObject.Builder builder = new RpcObject.Builder();
            builder.put("code", code);
            RpcItem message = this.properties.getItem("message");
            if (message != null) {
                builder.put("message", message);
            }
            failure = builder.build();
        }
        return failure != null ? new Failure(failure.asObject()) : null;
    }

    public String toString() {
        return "TransactionResult{properties=" + this.properties + '}';
    }

    public static class Failure {
        private RpcObject properties;

        private Failure(RpcObject properties) {
            this.properties = properties;
        }

        public BigInteger getCode() {
            RpcItem item = this.properties.getItem("code");
            return item != null ? item.asInteger() : null;
        }

        public String getMessage() {
            RpcItem item = this.properties.getItem("message");
            return item != null ? item.asString() : null;
        }

        public String toString() {
            return "Failure{properties=" + this.properties + '}';
        }
    }

    public class EventLog {
        private RpcObject properties;

        EventLog(RpcObject properties) {
            this.properties = properties;
        }

        public String getScoreAddress() {
            RpcItem item = this.properties.getItem("scoreAddress");
            return item != null ? item.asString() : null;
        }

        public List<RpcItem> getIndexed() {
            RpcItem item = this.properties.getItem("indexed");
            return item != null ? item.asArray().asList() : null;
        }

        public List<RpcItem> getData() {
            RpcItem field = this.properties.getItem("data");
            return field != null ? field.asArray().asList() : null;
        }

        public String toString() {
            return "EventLog{properties=" + this.properties + '}';
        }
    }
}

