/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import foundation.icon.icx.Callback;
import foundation.icon.icx.Request;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcError;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemDeserializer;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpCall<T>
implements Request<T> {
    private final Call httpCall;
    private final RpcConverter<T> converter;

    HttpCall(Call httpCall, RpcConverter<T> converter) {
        this.httpCall = httpCall;
        this.converter = converter;
    }

    @Override
    public T execute() throws IOException {
        return this.convertResponse(this.httpCall.execute());
    }

    @Override
    public void execute(final Callback<T> callback) {
        this.httpCall.enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(e);
            }

            public void onResponse(Call call, Response response) {
                try {
                    Object result = HttpCall.this.convertResponse(response);
                    callback.onSuccess(result);
                }
                catch (IOException e) {
                    callback.onFailure(e);
                }
            }
        });
    }

    private T convertResponse(Response httpResponse) throws IOException {
        ResponseBody body = httpResponse.body();
        if (body != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.registerModule((Module)this.createDeserializerModule());
            String content = body.string();
            foundation.icon.icx.transport.jsonrpc.Response response = (foundation.icon.icx.transport.jsonrpc.Response)mapper.readValue(content, foundation.icon.icx.transport.jsonrpc.Response.class);
            if (this.converter == null) {
                throw new IllegalArgumentException("There is no converter for response:'" + content + "'");
            }
            if (response.getResult() != null) {
                return this.converter.convertTo(response.getResult());
            }
            throw response.getError();
        }
        throw new RpcError(httpResponse.code(), httpResponse.message());
    }

    private SimpleModule createDeserializerModule() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(RpcItem.class, (JsonDeserializer)new RpcItemDeserializer());
        return module;
    }
}

