/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import foundation.icon.icx.Provider;
import foundation.icon.icx.Request;
import foundation.icon.icx.transport.http.HttpCall;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemSerializer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class HttpProvider
implements Provider {
    private final OkHttpClient httpClient;
    private String serverUri;
    private String endpointUri;
    private int version;
    private HashMap<String, String> urlMap;

    public HttpProvider(OkHttpClient httpClient, String url) {
        this(httpClient, true, url, 3);
    }

    public HttpProvider(OkHttpClient httpClient, String uri, int version) {
        this(httpClient, false, uri, version);
    }

    public HttpProvider(String url) {
        this(new OkHttpClient.Builder().build(), url);
    }

    public HttpProvider(String uri, int version) {
        this(new OkHttpClient.Builder().build(), uri, version);
    }

    private HttpProvider(OkHttpClient httpClient, boolean allowPath, String uri, int version) {
        this.httpClient = httpClient;
        if (version != 3) {
            throw new IllegalArgumentException("Unsupported version");
        }
        this.version = version;
        new Parser(uri).parse(allowPath);
        this.generateUrlMap();
    }

    @Override
    public <T> Request<T> request(final foundation.icon.icx.transport.jsonrpc.Request request, RpcConverter<T> converter) {
        String url;
        RequestBody body = new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/json");
            }

            public void writeTo(BufferedSink sink) throws IOException {
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                SimpleModule module = new SimpleModule();
                module.addSerializer(RpcItem.class, (JsonSerializer)new RpcItemSerializer());
                mapper.registerModule((Module)module);
                mapper.writeValue(sink.outputStream(), (Object)request);
            }
        };
        String method = request.getMethod();
        String prefix = method.substring(0, method.indexOf("_"));
        if (this.endpointUri != null) {
            if (!prefix.equals("icx")) {
                throw new UnsupportedOperationException("Unsupported operation in this provider");
            }
            url = this.endpointUri;
        } else {
            url = this.urlMap.get(prefix);
        }
        okhttp3.Request httpRequest = new Request.Builder().url(url).post(body).build();
        return new HttpCall<T>(this.httpClient.newCall(httpRequest), converter);
    }

    private void generateUrlMap() {
        this.urlMap = new HashMap();
        this.urlMap.put("icx", this.serverUri + "/api/v" + this.version);
        this.urlMap.put("debug", this.serverUri + "/api/debug/v" + this.version);
    }

    private class Parser {
        private final String input;

        Parser(String s) {
            this.input = s;
        }

        void parse(boolean allowPath) {
            try {
                URI uri = new URI(this.input);
                if (allowPath) {
                    HttpProvider.this.endpointUri = this.input;
                } else if (!"".equals(uri.getPath())) {
                    throw new IllegalArgumentException("Path is not allowed");
                }
                HttpProvider.this.serverUri = uri.getScheme() + "://" + uri.getAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }
}

