/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import foundation.icon.icx.data.Converters;
import foundation.icon.icx.transport.jsonrpc.ConverterName;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemCreator;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class AnnotatedConverterFactory
implements RpcConverter.RpcConverterFactory {
    @Override
    public <T> RpcConverter<T> create(final Class<T> type) {
        return new RpcConverter<T>(){

            @Override
            public T convertTo(RpcItem object) {
                try {
                    Field[] fields;
                    Object result;
                    try {
                        result = AnnotatedConverterFactory.this.getClassInstance(type);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                    RpcObject o = object.asObject();
                    for (Field field : fields = type.getDeclaredFields()) {
                        ConverterName n;
                        Object value;
                        field.setAccessible(true);
                        if (!field.isAnnotationPresent(ConverterName.class) || (value = Converters.fromRpcItem(o.getItem((n = field.getAnnotation(ConverterName.class)).value()), field.getType())) == null) continue;
                        field.set(result, value);
                    }
                    return result;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public RpcItem convertFrom(T object) {
                return RpcItemCreator.create(object);
            }
        };
    }

    private <T> T getClassInstance(Class<T> type) throws IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        if (this.isInnerClass(type)) {
            String className = type.getCanonicalName().subSequence(0, type.getCanonicalName().length() - type.getSimpleName().length() - 1).toString();
            Class<?> m = Class.forName(className);
            return type.getConstructor(m).newInstance(m.newInstance());
        }
        return type.newInstance();
    }

    private boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }
}

