/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;

public interface RpcItem {
    public boolean isEmpty();

    default public RpcObject asObject() {
        if (this instanceof RpcObject) {
            return (RpcObject)this;
        }
        throw new RpcValueException("This item can not be converted to RpcObject");
    }

    default public RpcArray asArray() {
        if (this instanceof RpcArray) {
            return (RpcArray)this;
        }
        throw new RpcValueException("This item can not be converted to RpcValue");
    }

    default public RpcValue asValue() {
        if (this instanceof RpcValue) {
            return (RpcValue)this;
        }
        throw new RpcValueException("This item can not be converted to RpcValue");
    }

    default public String asString() {
        return this.asValue().asString();
    }

    default public BigInteger asInteger() {
        return this.asValue().asInteger();
    }

    default public byte[] asByteArray() {
        return this.asValue().asByteArray();
    }

    default public Boolean asBoolean() {
        return this.asValue().asBoolean();
    }

    default public Address asAddress() {
        return this.asValue().asAddress();
    }

    default public Bytes asBytes() {
        return this.asValue().asBytes();
    }

    public static class RpcValueException
    extends IllegalArgumentException {
        RpcValueException(String message) {
            super(message);
        }
    }
}

