/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class RpcItemDeserializer
extends JsonDeserializer<RpcItem> {
    public RpcItem deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        TreeNode node = parser.readValueAsTree();
        return this.deserialize(node);
    }

    private RpcItem deserialize(TreeNode node) {
        if (node.isObject()) {
            RpcObject.Builder builder = new RpcObject.Builder();
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                TreeNode childNode = node.get(fieldName);
                builder.put(fieldName, this.deserialize(childNode));
            }
            return builder.build();
        }
        if (node.isArray()) {
            RpcArray.Builder builder = new RpcArray.Builder();
            for (int i = 0; i < node.size(); ++i) {
                TreeNode childNode = node.get(i);
                builder.add(this.deserialize(childNode));
            }
            return builder.build();
        }
        JsonNode n = (JsonNode)node;
        if (n.isLong()) {
            return new RpcValue(new BigInteger(String.valueOf(n.asLong())));
        }
        if (n.isInt()) {
            return new RpcValue(new BigInteger(String.valueOf(n.asInt())));
        }
        if (n.isBoolean()) {
            return new RpcValue(n.asBoolean());
        }
        return new RpcValue(n.asText());
    }
}

