/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.io.IOException;

public class RpcItemSerializer
extends JsonSerializer<RpcItem> {
    public void serialize(RpcItem item, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        this.serialize(item, gen);
    }

    private void serialize(RpcItem item, JsonGenerator gen) throws IOException {
        if (item instanceof RpcObject) {
            RpcObject object = item.asObject();
            gen.writeStartObject();
            for (String key : object.keySet()) {
                RpcItem value = object.getItem(key);
                if (value == null) continue;
                gen.writeFieldName(key);
                this.serialize(value, gen);
            }
            gen.writeEndObject();
        } else if (item instanceof RpcArray) {
            RpcArray array = item.asArray();
            gen.writeStartArray();
            for (RpcItem childItem : array) {
                this.serialize(childItem, gen);
            }
            gen.writeEndArray();
        } else {
            gen.writeString(item.asString());
        }
    }
}

