/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import foundation.icon.icx.transport.jsonrpc.RpcItem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RpcObject
implements RpcItem {
    private final Map<String, RpcItem> items;

    private RpcObject(Map<String, RpcItem> items) {
        this.items = items;
    }

    public Set<String> keySet() {
        return this.items.keySet();
    }

    public RpcItem getItem(String key) {
        return this.items.get(key);
    }

    public String toString() {
        return "RpcObject(items=" + this.items + ')';
    }

    @Override
    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public static class Builder {
        private final Map<String, RpcItem> items;

        public Builder() {
            this(Sort.NONE);
        }

        public Builder(Sort sort) {
            switch (sort) {
                case KEY: {
                    this.items = new TreeMap<String, RpcItem>();
                    break;
                }
                case INSERT: {
                    this.items = new LinkedHashMap<String, RpcItem>();
                    break;
                }
                default: {
                    this.items = new HashMap<String, RpcItem>();
                }
            }
        }

        public Builder put(String key, RpcItem item) {
            if (!this.items.containsKey(key) && !this.isNullOrEmpty(item)) {
                this.items.put(key, item);
            }
            return this;
        }

        public RpcObject build() {
            return new RpcObject(this.items);
        }

        public boolean isNullOrEmpty(RpcItem item) {
            return item == null || item.isEmpty();
        }

        public static enum Sort {
            NONE,
            KEY,
            INSERT;

        }
    }
}

