/*
 * Decompiled with CFR 0.152.
 */
package foundation.metaplex.rpc;

import foundation.metaplex.rpc.Cluster;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\u00a8\u0006\u000e"}, d2={"DEVNET_DOMAINS", "", "", "getDEVNET_DOMAINS", "()Ljava/util/List;", "LOCALNET_DOMAINS", "getLOCALNET_DOMAINS", "MAINNET_BETA_DOMAINS", "getMAINNET_BETA_DOMAINS", "TESTNET_DOMAINS", "getTESTNET_DOMAINS", "resolveClusterFromEndpoint", "Lfoundation/metaplex/rpc/Cluster;", "endpoint", "rpc"})
public final class ClusterKt {
    @NotNull
    private static final List<String> MAINNET_BETA_DOMAINS;
    @NotNull
    private static final List<String> DEVNET_DOMAINS;
    @NotNull
    private static final List<String> TESTNET_DOMAINS;
    @NotNull
    private static final List<String> LOCALNET_DOMAINS;

    @NotNull
    public static final List<String> getMAINNET_BETA_DOMAINS() {
        return MAINNET_BETA_DOMAINS;
    }

    @NotNull
    public static final List<String> getDEVNET_DOMAINS() {
        return DEVNET_DOMAINS;
    }

    @NotNull
    public static final List<String> getTESTNET_DOMAINS() {
        return TESTNET_DOMAINS;
    }

    @NotNull
    public static final List<String> getLOCALNET_DOMAINS() {
        return LOCALNET_DOMAINS;
    }

    @NotNull
    public static final Cluster resolveClusterFromEndpoint(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String domain = endpoint;
        if (MAINNET_BETA_DOMAINS.contains(domain)) {
            return Cluster.MainnetBeta.INSTANCE;
        }
        if (DEVNET_DOMAINS.contains(domain)) {
            return Cluster.Devnet.INSTANCE;
        }
        if (TESTNET_DOMAINS.contains(domain)) {
            return Cluster.Testnet.INSTANCE;
        }
        if (LOCALNET_DOMAINS.contains(domain)) {
            return Cluster.Localnet.INSTANCE;
        }
        if (StringsKt.contains$default((CharSequence)endpoint, (CharSequence)"mainnet", (boolean)false, (int)2, null)) {
            return Cluster.MainnetBeta.INSTANCE;
        }
        if (StringsKt.contains$default((CharSequence)endpoint, (CharSequence)"dev net", (boolean)false, (int)2, null)) {
            return Cluster.Devnet.INSTANCE;
        }
        if (StringsKt.contains$default((CharSequence)endpoint, (CharSequence)"testnet", (boolean)false, (int)2, null)) {
            return Cluster.Testnet.INSTANCE;
        }
        if (StringsKt.contains$default((CharSequence)endpoint, (CharSequence)"local", (boolean)false, (int)2, null)) {
            return Cluster.Localnet.INSTANCE;
        }
        return Cluster.Custom.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"api.mainnet-beta.solana.com", "ssc-dao.genesysgo.net"};
        MAINNET_BETA_DOMAINS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"api.devnet.solana.com", "psytrbhymqlkfrhudd.dev.genesysgo.net"};
        DEVNET_DOMAINS = CollectionsKt.listOf((Object[])objectArray);
        TESTNET_DOMAINS = CollectionsKt.listOf((Object)"api.testnet.solana.com");
        objectArray = new String[]{"localhost", "127.0.0.1"};
        LOCALNET_DOMAINS = CollectionsKt.listOf((Object[])objectArray);
    }
}

