/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.ext.sentry.ITimedAction;
import fr.alexpado.jda.interactions.impl.DefaultErrorHandler;
import fr.alexpado.jda.interactions.impl.interactions.autocomplete.AutocompleteInteractionContainerImpl;
import fr.alexpado.jda.interactions.impl.interactions.button.ButtonInteractionContainerImpl;
import fr.alexpado.jda.interactions.impl.interactions.slash.SlashInteractionContainerImpl;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionErrorHandler;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionEventHandler;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionPreprocessor;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionResponseHandler;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionTarget;
import fr.alexpado.jda.interactions.interfaces.interactions.autocomplete.AutocompleteInteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.button.ButtonInteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.slash.SlashInteractionContainer;
import fr.alexpado.jda.interactions.tools.InteractionUtils;
import io.sentry.Scope;
import io.sentry.Sentry;
import io.sentry.protocol.User;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.InteractionType;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.SlashCommandInteraction;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonInteraction;
import org.jetbrains.annotations.NotNull;

public class InteractionExtension
extends ListenerAdapter {
    private final Map<Class<? extends Interaction>, InteractionEventHandler<?>> handlers = new HashMap();
    private final Map<Class<? extends Interaction>, InteractionContainer<?, ?>> containers = new HashMap();
    private final Collection<InteractionResponseHandler> responseHandlers = new ArrayList<InteractionResponseHandler>();
    private final Collection<InteractionPreprocessor> preprocessors = new ArrayList<InteractionPreprocessor>();
    private final SlashInteractionContainer slashContainer;
    private final ButtonInteractionContainer buttonContainer;
    private final AutocompleteInteractionContainer autocompleteContainer;
    private InteractionErrorHandler errorHandler = new DefaultErrorHandler();

    public InteractionExtension() {
        this.slashContainer = new SlashInteractionContainerImpl();
        this.buttonContainer = new ButtonInteractionContainerImpl();
        this.autocompleteContainer = new AutocompleteInteractionContainerImpl();
        this.registerContainer(SlashCommandInteraction.class, this.slashContainer);
        this.registerContainer(ButtonInteraction.class, this.buttonContainer);
        this.registerContainer(CommandAutoCompleteInteraction.class, this.autocompleteContainer);
        this.registerHandler(SlashCommandInteraction.class, this.slashContainer);
        this.registerHandler(ButtonInteraction.class, this.buttonContainer);
        this.registerHandler(CommandAutoCompleteInteraction.class, this.autocompleteContainer);
    }

    public void useDefaultMapping() {
        for (InteractionContainer<?, ?> container : this.containers.values()) {
            container.addClassMapping(net.dv8tion.jda.api.entities.User.class, event -> () -> event.getInteraction().getUser());
            container.addClassMapping(Channel.class, event -> () -> event.getInteraction().getChannel());
            container.addClassMapping(GuildChannel.class, event -> () -> event.getInteraction().getGuildChannel());
            container.addClassMapping(Guild.class, event -> () -> event.getInteraction().getGuild());
            container.addClassMapping(ChannelType.class, event -> () -> event.getInteraction().getChannelType());
            container.addClassMapping(InteractionType.class, event -> () -> event.getInteraction().getType());
            container.addClassMapping(Member.class, event -> () -> event.getInteraction().getMember());
            container.addClassMapping(MessageChannel.class, event -> () -> event.getInteraction().getMessageChannel());
            container.addClassMapping(JDA.class, event -> () -> event.getInteraction().getJDA());
            container.addClassMapping(Interaction.class, event -> event::getInteraction);
            container.addClassMapping(ITimedAction.class, event -> event::getTimedAction);
        }
    }

    public SlashInteractionContainer getSlashContainer() {
        return this.slashContainer;
    }

    public ButtonInteractionContainer getButtonContainer() {
        return this.buttonContainer;
    }

    public AutocompleteInteractionContainer getAutocompleteContainer() {
        return this.autocompleteContainer;
    }

    public void setErrorHandler(InteractionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public <T extends Interaction> void registerHandler(Class<T> forInteraction, InteractionEventHandler<T> handler) {
        this.handlers.put(forInteraction, handler);
    }

    public <T extends Interaction> void registerContainer(Class<T> forInteraction, InteractionContainer<?, T> container) {
        this.containers.put(forInteraction, container);
    }

    public void registerResponseHandler(InteractionResponseHandler handler) {
        this.responseHandlers.add(handler);
    }

    public void registerPreprocessor(InteractionPreprocessor preprocessor) {
        this.preprocessors.add(preprocessor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Interaction, V extends InteractionTarget<T>, K extends InteractionContainer<V, T>> void run(String transactionName, Class<T> type, T discordEvent) {
        InteractionResponseHandler responseHandler;
        InteractionResponseHandler localHandler;
        Object result;
        InteractionContainer<?, ?> container;
        DispatchEvent<?> event;
        ITimedAction timedAction;
        block16: {
            timedAction = ITimedAction.create();
            timedAction.open(transactionName, "interaction", "Interaction received");
            if (!this.handlers.containsKey(type)) {
                throw new IllegalStateException("No handler for the provided interaction.");
            }
            if (!this.containers.containsKey(type)) {
                throw new IllegalStateException("No container for the provided interaction.");
            }
            timedAction.action("handling", "Handling the interaction");
            InteractionEventHandler<?> handler = this.handlers.get(type);
            event = handler.handle(timedAction, discordEvent);
            container = this.containers.get(type);
            timedAction.endAction();
            try {
                timedAction.action("preprocessors", "Calling preprocessors");
                if (!this.preprocessors.stream().allMatch(preprocessor -> preprocessor.mayContinue(event))) {
                    if (timedAction == null) return;
                    timedAction.close();
                    return;
                }
                result = this.preprocessors.stream().map(preprocessor -> preprocessor.preprocess(event)).filter(Optional::isPresent).findFirst().orElse(null);
                timedAction.endAction();
                if (result != null) break block16;
                timedAction.action("dispatching", "Dispatching the interaction");
            }
            catch (Exception e) {
                Sentry.captureException((Throwable)e);
                this.errorHandler.handleException(event, e);
                return;
            }
            result = container.dispatch(event);
            timedAction.endAction();
        }
        timedAction.action("answering", "Finding and using the response handler");
        if (container instanceof InteractionResponseHandler && (localHandler = (InteractionResponseHandler)((Object)container)).canHandle(event, result)) {
            responseHandler = localHandler;
        } else {
            Object finalResult = result;
            responseHandler = this.responseHandlers.stream().filter(registeredHandler -> registeredHandler.canHandle(event, finalResult)).findAny().orElse(null);
        }
        if (responseHandler == null) {
            this.errorHandler.onNoResponseHandlerFound(event, result);
            if (timedAction == null) return;
            timedAction.close();
            return;
        }
        responseHandler.handleResponse(event, result);
        timedAction.endAction();
        return;
    }

    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        Sentry.configureScope(scope -> this.createScope(scope, (Interaction)event, "slash", event.getCommandPath()));
        String transaction = "slash://%s".formatted(event.getCommandPath());
        try {
            this.run(transaction, SlashCommandInteraction.class, event);
        }
        catch (Exception e) {
            Sentry.captureException((Throwable)e);
        }
        Sentry.popScope();
    }

    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        String transaction;
        Sentry.configureScope(scope -> this.createScope(scope, (Interaction)event, "button", event.getComponentId()));
        try {
            URI uri = URI.create(event.getComponentId());
            transaction = "%s://%s%s".formatted(uri.getScheme(), uri.getHost(), uri.getPath());
        }
        catch (Exception ignore) {
            transaction = "button://%s".formatted(event.getComponentId());
        }
        try {
            this.run(transaction, ButtonInteraction.class, event);
        }
        catch (Exception e) {
            Sentry.captureException((Throwable)e);
        }
        Sentry.popScope();
    }

    public void onCommandAutoCompleteInteraction(@NotNull CommandAutoCompleteInteractionEvent event) {
        Sentry.configureScope(scope -> this.createScope(scope, (Interaction)event, "auto-complete", event.getCommandPath()));
        String transaction = "complete://%s".formatted(event.getCommandPath());
        try {
            this.run(transaction, CommandAutoCompleteInteraction.class, event);
        }
        catch (Exception e) {
            Sentry.captureException((Throwable)e);
        }
        Sentry.popScope();
    }

    private void createScope(Scope scope, Interaction interaction, String type, String description) {
        HashMap<String, String> extra = new HashMap<String, String>();
        net.dv8tion.jda.api.entities.User user = interaction.getUser();
        Channel channel = interaction.getChannel();
        Guild guild = interaction.getGuild();
        User sentryUser = new User();
        sentryUser.setId(user.getId());
        sentryUser.setEmail("%s@discordapp.com".formatted(user.getId()));
        sentryUser.setUsername(user.getAsTag());
        scope.setUser(sentryUser);
        scope.setTag("category", "interaction");
        scope.setTag("type", "auto-complete");
        scope.setTag("interaction", interaction.getId());
        scope.setTag("description", description);
        scope.setTag("user", user.getId());
        extra.put("user", user.getAsTag());
        if (channel != null) {
            scope.setTag("channel", channel.getId());
            extra.put("channel", channel.getName());
        }
        if (guild != null) {
            scope.setTag("guild", guild.getId());
            extra.put("guild", guild.getName());
        }
        if (interaction instanceof SlashCommandInteraction) {
            SlashCommandInteraction slash = (SlashCommandInteraction)interaction;
            HashMap<String, Object> options = new HashMap<String, Object>();
            for (OptionMapping option : slash.getOptions()) {
                options.put(option.getName(), InteractionUtils.extractOptionValue(option));
            }
            scope.setContexts("Interaction", options);
        }
        scope.setContexts("Discord", extra);
    }
}

