/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.exceptions;

import fr.alexpado.jda.interactions.interfaces.DiscordEmbeddable;
import java.lang.reflect.Method;
import net.dv8tion.jda.api.EmbedBuilder;

public class InteractionDeclarationException
extends RuntimeException
implements DiscordEmbeddable {
    private final Class<?> declarationClass;
    private final Method declarationMethod;
    private final String path;

    public InteractionDeclarationException(Class<?> declarationClass, Method declarationMethod, String path, String message) {
        super(message);
        this.declarationClass = declarationClass;
        this.declarationMethod = declarationMethod;
        this.path = path;
    }

    public Class<?> getDeclarationClass() {
        return this.declarationClass;
    }

    public Method getDeclarationMethod() {
        return this.declarationMethod;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String getMessage() {
        return String.format("[%s] (%s::%s) %s", this.getPath(), this.getDeclarationClass().getSimpleName(), this.getDeclarationMethod().getName(), super.getMessage());
    }

    @Override
    public EmbedBuilder asEmbed() {
        EmbedBuilder builder = new EmbedBuilder();
        builder.setDescription((CharSequence)super.getMessage());
        builder.addField("Class", this.declarationClass.getSimpleName(), false);
        builder.addField("Method", this.declarationMethod.getName(), false);
        builder.addField("Path", this.path, false);
        return builder;
    }

    @Override
    public boolean showToEveryone() {
        return false;
    }
}

