/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.exceptions;

import fr.alexpado.jda.interactions.interfaces.DiscordEmbeddable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import net.dv8tion.jda.api.EmbedBuilder;

public class InteractionInjectionException
extends Exception
implements DiscordEmbeddable {
    private final Class<?> source;
    private final Method method;
    private final Parameter parameter;

    public InteractionInjectionException(Exception cause, Class<?> source, Method method, Parameter parameter) {
        super(String.format("Failed to inject dependency %s on %s@%s: %s", parameter.getType().getTypeName(), method.getName(), parameter.getName(), cause.getMessage()), cause);
        this.source = source;
        this.method = method;
        this.parameter = parameter;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public Method getMethod() {
        return this.method;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public EmbedBuilder asEmbed() {
        EmbedBuilder builder = new EmbedBuilder();
        builder.setDescription((CharSequence)"Failed to inject dependency");
        builder.addField("Class", this.source.getSimpleName(), false);
        builder.addField("Method", this.method.getName(), false);
        builder.addField("Parameter", this.parameter.getName(), false);
        return builder;
    }

    @Override
    public boolean showToEveryone() {
        return false;
    }
}

