/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.exceptions;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.interfaces.DiscordEmbeddable;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionContainer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.interactions.Interaction;

public class InteractionNotFoundException
extends RuntimeException
implements DiscordEmbeddable {
    private final InteractionContainer<?, ?> container;
    private final DispatchEvent<?> event;

    public <T extends Interaction> InteractionNotFoundException(InteractionContainer<?, T> container, DispatchEvent<T> event) {
        super(String.format("Interaction '%s' not found in container '%s'", event.getPath(), container.getClass().getName()));
        this.container = container;
        this.event = event;
    }

    public DispatchEvent<?> getEvent() {
        return this.event;
    }

    public InteractionContainer<?, ?> getContainer() {
        return this.container;
    }

    @Override
    public EmbedBuilder asEmbed() {
        EmbedBuilder builder = new EmbedBuilder();
        builder.setTitle("Unable to find the requested interaction");
        builder.setDescription((CharSequence)"Please check your declaration and make sure that you registered your interaction target.");
        builder.addField("URI", "`%s`".formatted(this.event.getPath()), false);
        builder.addField("Context", this.event.getInteraction().getClass().getSimpleName(), false);
        builder.addField("Container", this.container.getClass().getSimpleName(), false);
        builder.addField("Options", String.valueOf(this.event.getOptions().size()), false);
        return builder;
    }

    @Override
    public boolean showToEveryone() {
        return false;
    }
}

