/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.ext.discord;

import fr.alexpado.jda.interactions.ext.discord.InteractionGroupData;
import fr.alexpado.jda.interactions.ext.discord.InteractionSubcommandData;
import fr.alexpado.jda.interactions.meta.InteractionMeta;
import fr.alexpado.jda.interactions.meta.OptionMeta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.dv8tion.jda.internal.interactions.CommandDataImpl;
import org.jetbrains.annotations.NotNull;

public class InteractionCommandData
extends CommandDataImpl {
    private final Map<String, InteractionGroupData> groups = new HashMap<String, InteractionGroupData>();
    private final Map<String, InteractionSubcommandData> subCommands = new HashMap<String, InteractionSubcommandData>();

    public InteractionCommandData(@NotNull String name, @NotNull InteractionMeta meta) {
        super(name, meta.getDescription());
    }

    public void prepare() {
        block3: {
            block2: {
                if (this.groups.isEmpty()) break block2;
                for (InteractionGroupData value : this.groups.values()) {
                    value.prepare();
                    this.addSubcommandGroups(new SubcommandGroupData[]{value});
                }
                break block3;
            }
            if (this.subCommands.isEmpty()) break block3;
            for (InteractionSubcommandData value : this.subCommands.values()) {
                this.addSubcommands(new SubcommandData[]{value});
            }
        }
    }

    public void register(InteractionMeta meta) {
        boolean hasSubGroupError;
        List<String> path = Arrays.asList(meta.getName().split("/"));
        boolean isOverflowing = path.size() > 3;
        boolean hasGroupError = path.size() == 2 && !this.groups.isEmpty();
        boolean bl = hasSubGroupError = path.size() == 3 && !this.subCommands.isEmpty();
        if (isOverflowing || hasGroupError || hasSubGroupError) {
            throw new IllegalStateException(String.format("Invalid nesting for %s", meta.getName()));
        }
        if (path.size() == 1) {
            this.addOptions(meta.getOptions().stream().map(OptionMeta::createOptionData).toList());
        } else if (path.size() == 2) {
            String name = path.get(1);
            InteractionSubcommandData data = this.subCommands.getOrDefault(name, new InteractionSubcommandData(name, meta));
            this.subCommands.put(name, data);
        } else if (path.size() == 3) {
            String name = path.get(1);
            InteractionGroupData data = this.groups.getOrDefault(name, new InteractionGroupData(name, meta));
            data.register(meta);
            this.groups.put(name, data);
        }
    }
}

