/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.ext.sentry;

import fr.alexpado.jda.interactions.ext.sentry.ITimedAction;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Sentry;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class TimedAction
implements ITimedAction {
    private final BlockingDeque<ISpan> span = new LinkedBlockingDeque<ISpan>();
    private ITransaction transaction;

    TimedAction() {
    }

    @Override
    public void open(String transaction, String name, String description) {
        this.transaction = Sentry.startTransaction((String)transaction, (String)name, (boolean)true);
        this.transaction.setDescription(description);
    }

    @Override
    public void close() {
        while (!this.span.isEmpty()) {
            ISpan span = (ISpan)this.span.pollLast();
            if (span == null) continue;
            span.finish();
        }
        this.transaction.finish();
    }

    @Override
    public void action(String name, String description) {
        if (this.span.isEmpty()) {
            this.span.offer(this.transaction.startChild(name, description));
            return;
        }
        this.span.offer(((ISpan)this.span.getLast()).startChild(name, description));
    }

    @Override
    public void endAction() {
        if (this.span.isEmpty()) {
            return;
        }
        ISpan span = (ISpan)this.span.pollLast();
        if (span != null) {
            span.finish();
        }
    }
}

