/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.interfaces.DiscordEmbeddable;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionErrorHandler;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.callbacks.IDeferrableCallback;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;

public class DefaultErrorHandler
implements InteractionErrorHandler {
    @Override
    public <T extends Interaction> void handleException(DispatchEvent<T> event, Exception exception) {
        T t = event.getInteraction();
        if (t instanceof IReplyCallback) {
            IReplyCallback callback = (IReplyCallback)t;
            if (exception instanceof DiscordEmbeddable) {
                DiscordEmbeddable embeddable = (DiscordEmbeddable)((Object)exception);
                EmbedBuilder builder = embeddable.asEmbed();
                this.answer(callback, builder.build(), !embeddable.showToEveryone());
                return;
            }
            EmbedBuilder builder = new EmbedBuilder();
            builder.setTitle("An error occurred.");
            builder.setDescription((CharSequence)exception.getMessage());
            builder.setFooter("You can remove this message by creating your own error handler.");
            this.answer(callback, builder.build(), true);
        }
    }

    @Override
    public <T extends Interaction> void onNoResponseHandlerFound(DispatchEvent<T> event, Object response) {
        T t = event.getInteraction();
        if (t instanceof IReplyCallback) {
            IReplyCallback callback = (IReplyCallback)t;
            EmbedBuilder builder = new EmbedBuilder();
            builder.setTitle("Unable to find a response handler");
            builder.setDescription((CharSequence)"Your interaction has been executed, but the response generated from the interaction target could not be handled.\n");
            builder.appendDescription((CharSequence)"If you have created your own response handler, please make sure you registered it.");
            builder.setFooter("You can remove this message by creating your own error handler.");
            this.answer(callback, builder.build(), true);
        }
    }

    private <T extends Interaction & IReplyCallback> void answer(T interaction, MessageEmbed embed, boolean ephemeral) {
        if (interaction.isAcknowledged()) {
            ((IDeferrableCallback)interaction).getHook().editOriginalEmbeds(new MessageEmbed[]{embed}).complete();
        } else {
            ((IReplyCallback)interaction).replyEmbeds(embed, new MessageEmbed[0]).setEphemeral(ephemeral).complete();
        }
    }
}

