/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl;

import fr.alexpado.jda.interactions.annotations.Param;
import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.exceptions.InteractionDeclarationException;
import fr.alexpado.jda.interactions.exceptions.InteractionInjectionException;
import fr.alexpado.jda.interactions.interfaces.interactions.Injection;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionTarget;
import fr.alexpado.jda.interactions.interfaces.interactions.MetaContainer;
import fr.alexpado.jda.interactions.meta.InteractionMeta;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Map;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.callbacks.IMessageEditCallback;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractionTargetImpl<T extends Interaction>
implements InteractionTarget<T>,
MetaContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InteractionTargetImpl.class);
    private final Object instance;
    private final Method method;
    private final InteractionMeta meta;

    public InteractionTargetImpl(Object instance, Method method, InteractionMeta meta) {
        this.instance = instance;
        this.method = method;
        this.meta = meta;
    }

    @Override
    public Object execute(DispatchEvent<T> event, Map<Class<?>, Injection<DispatchEvent<T>, ?>> mapping) throws Exception {
        if (this.getMeta().isDeferred()) {
            event.getTimedAction().action("deferring", "Deferring the interaction");
            boolean reply = this.getMeta().shouldReply();
            T t = event.getInteraction();
            if (reply && t instanceof IReplyCallback) {
                IReplyCallback callback = (IReplyCallback)t;
                callback.deferReply(this.getMeta().isHidden()).complete();
            } else if (!reply && t instanceof IMessageEditCallback) {
                IMessageEditCallback callback = (IMessageEditCallback)t;
                callback.deferEdit().complete();
            } else {
                throw new UnsupportedOperationException("Couldn't pre-handle deferred request");
            }
            event.getTimedAction().endAction();
        }
        event.getTimedAction().action("injection", "Injecting parameters");
        ArrayList<Object> callParameters = new ArrayList<Object>();
        for (Parameter parameter : this.method.getParameters()) {
            event.getTimedAction().action("param", "Injecting " + parameter.getName());
            String name = parameter.getName();
            String type = parameter.getType().getSimpleName();
            boolean isOption = parameter.isAnnotationPresent(Param.class);
            boolean isInjection = mapping.containsKey(parameter.getType());
            LOGGER.debug("Parameter {} is type {} (Option: {}, Injection: {})", new Object[]{name, type, isOption, isInjection});
            if (isOption) {
                Param param = parameter.getAnnotation(Param.class);
                callParameters.add(event.getOptions().get(param.value()));
            } else if (isInjection) {
                Injection<DispatchEvent<DispatchEvent<T>>, ?> injection = mapping.get(parameter.getType());
                try {
                    callParameters.add(injection.inject(event).get());
                }
                catch (Exception e) {
                    throw new InteractionInjectionException(e, this.instance.getClass(), this.method, parameter);
                }
            } else {
                throw new InteractionDeclarationException(this.instance.getClass(), this.method, this.meta.getName(), "Unmapped parameter " + type);
            }
            event.getTimedAction().endAction();
        }
        event.getTimedAction().endAction();
        try {
            event.getTimedAction().action("invoke", "Running the interaction");
            Object object = this.method.invoke(this.instance, (Object[])callParameters.toArray(Object[]::new));
            event.getTimedAction().endAction();
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw invocationTargetException;
        }
    }

    @Override
    public InteractionMeta getMeta() {
        return this.meta;
    }
}

