/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl.handlers;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionResponseHandler;
import java.util.function.Consumer;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.callbacks.IDeferrableCallback;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.SlashCommandInteraction;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonInteraction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.Nullable;

public class SinkResponseHandler
implements InteractionResponseHandler {
    @Override
    public <T extends Interaction> boolean canHandle(DispatchEvent<T> event, @Nullable Object response) {
        return response == null;
    }

    @Override
    public <T extends Interaction> void handleResponse(DispatchEvent<T> event, @Nullable Object response) {
        T t = event.getInteraction();
        if (t instanceof SlashCommandInteraction) {
            SlashCommandInteraction slash = (SlashCommandInteraction)t;
            this.answer(slash, data -> data.setContent("*Nothing to display*"));
        } else {
            t = event.getInteraction();
            if (t instanceof ButtonInteraction) {
                ButtonInteraction button = (ButtonInteraction)t;
                if (!button.isAcknowledged()) {
                    button.deferReply().complete();
                }
            } else {
                t = event.getInteraction();
                if (t instanceof CommandAutoCompleteInteraction) {
                    CommandAutoCompleteInteraction auto = (CommandAutoCompleteInteraction)t;
                    auto.replyChoices(new Command.Choice[0]).complete();
                }
            }
        }
    }

    private <T extends Interaction & IReplyCallback> void answer(T interaction, Consumer<MessageRequest<?>> consumer) {
        if (interaction.isAcknowledged()) {
            MessageEditBuilder builder = new MessageEditBuilder();
            consumer.accept((MessageRequest<?>)builder);
            ((IDeferrableCallback)interaction).getHook().editOriginal(builder.build()).complete();
        } else {
            MessageCreateBuilder builder = new MessageCreateBuilder();
            consumer.accept((MessageRequest<?>)builder);
            ((IReplyCallback)interaction).reply(builder.build()).setEphemeral(true).complete();
        }
    }
}

