/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl.interactions;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.exceptions.InteractionNotFoundException;
import fr.alexpado.jda.interactions.ext.sentry.ITimedAction;
import fr.alexpado.jda.interactions.interfaces.interactions.Injection;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionEventHandler;
import fr.alexpado.jda.interactions.interfaces.interactions.InteractionTarget;
import fr.alexpado.jda.interactions.interfaces.interactions.MetaContainer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.dv8tion.jda.api.interactions.Interaction;

public abstract class DefaultInteractionContainer<T extends InteractionTarget<U> & MetaContainer, U extends Interaction>
implements InteractionContainer<T, U>,
InteractionEventHandler<U> {
    private final Map<URI, T> interactions = new HashMap<URI, T>();
    private final Map<Class<?>, Injection<DispatchEvent<U>, ?>> mappings = new HashMap();

    @Override
    public URI createURI(String path) {
        return URI.create(String.format("%s://%s", this.getInteractionSchema(), path));
    }

    @Override
    public boolean register(T target) {
        URI uri = this.createURI(((MetaContainer)target).getMeta().getName());
        if (this.getInteractions().containsKey(uri)) {
            return false;
        }
        this.getInteractions().put(uri, target);
        return true;
    }

    @Override
    public Map<URI, T> getInteractions() {
        return this.interactions;
    }

    @Override
    public Optional<T> resolve(URI uri) {
        return Optional.ofNullable((InteractionTarget)this.getInteractions().get(uri));
    }

    @Override
    public Object dispatch(DispatchEvent<U> event) throws Exception {
        event.getTimedAction().action("resolve", "Finding the interaction target");
        Optional<T> optionalTarget = this.resolve(event.getPath());
        if (optionalTarget.isEmpty()) {
            throw new InteractionNotFoundException(this, event);
        }
        event.getTimedAction().endAction();
        event.getTimedAction().action("execute", "Running the interaction target");
        InteractionTarget target = (InteractionTarget)optionalTarget.get();
        Object obj = target.execute(event, this.getMappedClasses());
        event.getTimedAction().endAction();
        return obj;
    }

    @Override
    public <K> void addClassMapping(Class<K> clazz, Injection<DispatchEvent<U>, K> mapper) {
        this.getMappedClasses().put(clazz, mapper);
    }

    @Override
    public Map<Class<?>, Injection<DispatchEvent<U>, ?>> getMappedClasses() {
        return this.mappings;
    }

    @Override
    public DispatchEvent<U> handle(ITimedAction timedAction, U event) {
        return new DispatchEvent<U>(timedAction, this.getEventUri(event), event);
    }
}

