/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl.interactions.autocomplete;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.interfaces.interactions.Injection;
import fr.alexpado.jda.interactions.interfaces.interactions.autocomplete.AutoCompleteProvider;
import fr.alexpado.jda.interactions.interfaces.interactions.autocomplete.AutocompleteInteractionTarget;
import fr.alexpado.jda.interactions.meta.ChoiceMeta;
import fr.alexpado.jda.interactions.meta.InteractionMeta;
import fr.alexpado.jda.interactions.meta.OptionMeta;
import fr.alexpado.jda.interactions.responses.AutoCompleteResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;

public class AutocompleteInteractionTargetImpl
implements AutocompleteInteractionTarget {
    private final InteractionMeta meta;
    private final Map<String, AutoCompleteProvider> completionProviders;

    public AutocompleteInteractionTargetImpl(InteractionMeta meta) {
        this.meta = meta;
        this.completionProviders = new HashMap<String, AutoCompleteProvider>();
    }

    public AutoCompleteResponse execute(DispatchEvent<CommandAutoCompleteInteraction> event, Map<Class<?>, Injection<DispatchEvent<CommandAutoCompleteInteraction>, ?>> mapping) {
        CommandAutoCompleteInteraction interaction = event.getInteraction();
        AutoCompleteQuery focused = interaction.getFocusedOption();
        String name = focused.getName();
        String value = focused.getValue();
        if (this.completionProviders.containsKey(name)) {
            return () -> this.completionProviders.get(name).complete(event, name, value);
        }
        return () -> this.meta.getOptions().stream().filter(option -> option.getName().equals(name)).map(OptionMeta::getChoices).flatMap(Collection::stream).filter(choice -> choice.contains(value)).map(ChoiceMeta::asChoice).toList();
    }

    @Override
    public void addCompletionProvider(String name, AutoCompleteProvider provider) {
        this.completionProviders.put(name, provider);
    }

    @Override
    public void removeCompletionProvider(String name) {
        this.completionProviders.remove(name);
    }

    @Override
    public InteractionMeta getMeta() {
        return this.meta;
    }
}

