/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl.interactions.button;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.exceptions.InteractionNotFoundException;
import fr.alexpado.jda.interactions.ext.sentry.ITimedAction;
import fr.alexpado.jda.interactions.impl.interactions.DefaultInteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.button.ButtonInteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.button.ButtonInteractionTarget;
import fr.alexpado.jda.interactions.meta.OptionMeta;
import fr.alexpado.jda.interactions.responses.ButtonResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonInteraction;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.Nullable;

public class ButtonInteractionContainerImpl
extends DefaultInteractionContainer<ButtonInteractionTarget, ButtonInteraction>
implements ButtonInteractionContainer {
    @Override
    public String getInteractionSchema() {
        return "button";
    }

    @Override
    public Optional<ButtonInteractionTarget> resolve(URI uri) {
        try {
            URI raw = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
            return super.resolve(raw);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public Object dispatch(DispatchEvent<ButtonInteraction> event) throws Exception {
        event.getTimedAction().action("resolve", "Finding the interaction target");
        Optional<ButtonInteractionTarget> optionalTarget = this.resolve(event.getPath());
        if (optionalTarget.isEmpty()) {
            throw new InteractionNotFoundException(this, event);
        }
        event.getTimedAction().endAction();
        ButtonInteractionTarget target = optionalTarget.get();
        event.getTimedAction().action("convert", "Converting URI to interaction options");
        HashMap<String, String> query = new HashMap<String, String>();
        if (event.getPath().getQuery() != null) {
            String[] options;
            for (String option : options = event.getPath().getQuery().split("&")) {
                String[] parts = option.split("=");
                query.put(parts[0], parts[1]);
            }
        }
        block10: for (OptionMeta option : target.getMeta().getOptions()) {
            String name = option.getName();
            String value = (String)query.get(name);
            if (null == value) {
                if (option.isRequired()) {
                    throw new IllegalStateException(String.format("Option %s is required.", name));
                }
                event.getOptions().put(name, null);
                continue;
            }
            switch (option.getType()) {
                case STRING: {
                    event.getOptions().put(name, value);
                    continue block10;
                }
                case INTEGER: {
                    event.getOptions().put(name, Long.parseLong(value));
                    continue block10;
                }
                case BOOLEAN: {
                    event.getOptions().put(name, Boolean.parseBoolean(value));
                    continue block10;
                }
                case USER: {
                    long id = Long.parseLong(value);
                    event.getOptions().put(name, event.getInteraction().getJDA().getUserById(id));
                    continue block10;
                }
                case CHANNEL: {
                    long id = Long.parseLong(value);
                    Guild guild = event.getInteraction().getGuild();
                    if (null == guild) {
                        throw new IllegalStateException("Cannot load guild in a private channel context.");
                    }
                    event.getOptions().put(name, guild.getGuildChannelById(id));
                    continue block10;
                }
                case ROLE: {
                    long id = Long.parseLong(value);
                    Guild guild = event.getInteraction().getGuild();
                    if (null == guild) {
                        throw new IllegalStateException("Cannot load guild in a private channel context.");
                    }
                    event.getOptions().put(name, guild.getRoleById(id));
                    continue block10;
                }
                case NUMBER: {
                    event.getOptions().put(name, Double.parseDouble(value));
                    continue block10;
                }
            }
            event.getOptions().put(name, null);
        }
        event.getTimedAction().endAction();
        event.getTimedAction().action("execute", "Running the interaction target");
        Object obj = target.execute(event, this.getMappedClasses());
        event.getTimedAction().endAction();
        return obj;
    }

    @Override
    public URI getEventUri(ButtonInteraction event) {
        if (event.getComponentId().matches(".*://.*")) {
            return URI.create(event.getComponentId());
        }
        return this.createURI(event.getComponentId());
    }

    @Override
    public <T extends Interaction> boolean canHandle(DispatchEvent<T> event, @Nullable Object response) {
        return response instanceof ButtonResponse;
    }

    @Override
    public <T extends Interaction> void handleResponse(DispatchEvent<T> event, @Nullable Object response) {
        T t = event.getInteraction();
        if (t instanceof ButtonInteraction) {
            ButtonInteraction callback = (ButtonInteraction)t;
            if (response instanceof ButtonResponse) {
                ButtonResponse buttonResponse = (ButtonResponse)response;
                if (callback.isAcknowledged()) {
                    this.doResponseHandling(event.getTimedAction(), buttonResponse, arg_0 -> ((InteractionHook)callback.getHook()).editOriginal(arg_0), arg_0 -> ((InteractionHook)callback.getHook()).sendMessage(arg_0));
                } else {
                    this.doResponseHandling(event.getTimedAction(), buttonResponse, arg_0 -> ((ButtonInteraction)callback).editMessage(arg_0), arg_0 -> ((ButtonInteraction)callback).reply(arg_0));
                }
            }
        }
    }

    private void doResponseHandling(ITimedAction action, ButtonResponse response, Function<MessageEditData, RestAction<?>> editCall, Function<MessageCreateData, RestAction<?>> createCall) {
        if (response.shouldEditOriginalMessage()) {
            action.action("build", "Building the response");
            MessageEditBuilder builder = this.getMessageEditBuilder(response);
            action.endAction();
            action.action("reply", "Replying to the interaction (EDIT)");
            editCall.apply(builder.build()).complete();
            action.endAction();
        } else {
            action.action("build", "Building the response");
            MessageCreateBuilder builder = this.getMessageCreateBuilder(response);
            action.endAction();
            action.action("reply", "Replying to the interaction (CREATE)");
            createCall.apply(builder.build()).complete();
            action.endAction();
        }
    }

    private MessageEditBuilder getMessageEditBuilder(ButtonResponse response) {
        MessageEditBuilder builder = new MessageEditBuilder();
        response.getHandler().accept((MessageRequest<?>)builder);
        return builder;
    }

    private MessageCreateBuilder getMessageCreateBuilder(ButtonResponse response) {
        MessageCreateBuilder builder = new MessageCreateBuilder();
        response.getHandler().accept((MessageRequest<?>)builder);
        return builder;
    }
}

