/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.impl.interactions.slash;

import fr.alexpado.jda.interactions.entities.DispatchEvent;
import fr.alexpado.jda.interactions.ext.discord.InteractionCommandData;
import fr.alexpado.jda.interactions.ext.sentry.ITimedAction;
import fr.alexpado.jda.interactions.impl.interactions.DefaultInteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.slash.SlashInteractionContainer;
import fr.alexpado.jda.interactions.interfaces.interactions.slash.SlashInteractionTarget;
import fr.alexpado.jda.interactions.meta.InteractionMeta;
import fr.alexpado.jda.interactions.responses.SlashResponse;
import fr.alexpado.jda.interactions.tools.InteractionUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.SlashCommandInteraction;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.Nullable;

public class SlashInteractionContainerImpl
extends DefaultInteractionContainer<SlashInteractionTarget, SlashCommandInteraction>
implements SlashInteractionContainer {
    private final Map<String, InteractionCommandData> dataMap = new HashMap<String, InteractionCommandData>();

    @Override
    public boolean register(SlashInteractionTarget target) {
        InteractionMeta meta = target.getMeta();
        String name = meta.getName();
        String prefix = Arrays.asList(name.split("/")).get(0);
        InteractionCommandData data = this.dataMap.getOrDefault(prefix, new InteractionCommandData(prefix, meta));
        data.register(meta);
        this.dataMap.put(prefix, data);
        return super.register(target);
    }

    @Override
    public String getInteractionSchema() {
        return "slash";
    }

    @Override
    public URI getEventUri(SlashCommandInteraction event) {
        return this.createURI(event.getCommandPath());
    }

    @Override
    public DispatchEvent<SlashCommandInteraction> handle(ITimedAction timedAction, SlashCommandInteraction event) {
        URI uri = this.getEventUri(event);
        timedAction.action("read-options", "Reading command options");
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (OptionMapping option : event.getOptions()) {
            options.put(option.getName(), InteractionUtils.extractOptionValue(option));
        }
        timedAction.endAction();
        return new DispatchEvent<SlashCommandInteraction>(timedAction, uri, event, options);
    }

    @Override
    public <T extends Interaction> boolean canHandle(DispatchEvent<T> event, @Nullable Object response) {
        return response instanceof SlashResponse;
    }

    @Override
    public <T extends Interaction> void handleResponse(DispatchEvent<T> event, @Nullable Object response) {
        T t = event.getInteraction();
        if (t instanceof IReplyCallback) {
            IReplyCallback callback = (IReplyCallback)t;
            if (response instanceof SlashResponse) {
                SlashResponse slashResponse = (SlashResponse)response;
                if (callback.isAcknowledged()) {
                    event.getTimedAction().action("build", "Building the response");
                    builder = this.getMessageEditBuilder(slashResponse);
                    event.getTimedAction().endAction();
                    event.getTimedAction().action("reply", "Replying to the interaction (EDIT)");
                    callback.getHook().editOriginal(builder.build()).complete();
                    event.getTimedAction().endAction();
                } else {
                    event.getTimedAction().action("build", "Building the response");
                    builder = this.getMessageCreateBuilder(slashResponse);
                    event.getTimedAction().endAction();
                    event.getTimedAction().action("reply", "Replying to the interaction (CREATE)");
                    callback.reply(builder.build()).complete();
                    event.getTimedAction().endAction();
                }
            }
        }
    }

    private MessageEditBuilder getMessageEditBuilder(SlashResponse response) {
        MessageEditBuilder builder = new MessageEditBuilder();
        response.getHandler().accept((MessageRequest<?>)builder);
        return builder;
    }

    private MessageCreateBuilder getMessageCreateBuilder(SlashResponse response) {
        MessageCreateBuilder builder = new MessageCreateBuilder();
        response.getHandler().accept((MessageRequest<?>)builder);
        return builder;
    }

    @Override
    public CommandListUpdateAction upsertCommands(CommandListUpdateAction action) {
        for (InteractionCommandData command : this.dataMap.values()) {
            command.prepare();
            action.addCommands(new CommandData[]{command});
        }
        return action;
    }
}

