/*
 * Decompiled with CFR 0.152.
 */
package fr.alexpado.jda.interactions.meta;

import fr.alexpado.jda.interactions.annotations.Option;
import fr.alexpado.jda.interactions.meta.ChoiceMeta;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;

public class OptionMeta {
    private final String name;
    private final String description;
    private final List<ChoiceMeta> choices;
    private final boolean required;
    private final boolean autoCompletable;
    private final OptionType type;

    public OptionMeta(String name, String description, boolean required, boolean autoCompletable, OptionType type) {
        this(name, description, required, autoCompletable, type, Collections.emptyList());
    }

    public OptionMeta(String name, String description, boolean required, boolean autoCompletable, OptionType type, List<ChoiceMeta> choices) {
        this.name = name;
        this.description = description;
        this.choices = choices;
        this.required = required;
        this.autoCompletable = autoCompletable;
        this.type = type;
    }

    public OptionMeta(Option option) {
        this.name = option.name();
        this.description = option.description();
        this.choices = Arrays.stream(option.choices()).map(ChoiceMeta::new).toList();
        this.required = option.required();
        this.autoCompletable = option.autoComplete();
        this.type = option.type();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ChoiceMeta> getChoices() {
        return this.choices;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAutoCompletable() {
        return this.autoCompletable;
    }

    public OptionType getType() {
        return this.type;
    }

    public OptionData createOptionData() {
        OptionData optionData = new OptionData(this.getType(), this.getName(), this.getDescription(), this.isRequired(), this.isAutoCompletable());
        for (ChoiceMeta choice : this.getChoices()) {
            if (OptionType.INTEGER == this.getType()) {
                optionData.addChoice(choice.getDisplay(), (long)Integer.parseInt(choice.getId()));
                continue;
            }
            optionData.addChoice(choice.getDisplay(), choice.getId());
        }
        return optionData;
    }
}

