/*
 * Decompiled with CFR 0.152.
 */
package armonik.client.event;

import armonik.api.grpc.v1.FiltersCommon;
import armonik.api.grpc.v1.events.EventsCommon;
import armonik.api.grpc.v1.events.EventsGrpc;
import armonik.api.grpc.v1.results.ResultsFields;
import armonik.api.grpc.v1.results.ResultsFilters;
import armonik.client.event.util.records.EventSubscriptionResponseRecord;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EventClient {
    private final EventsGrpc.EventsBlockingStub eventsBlockingStub;
    private final EventsGrpc.EventsStub eventsStub;

    public EventClient(ManagedChannel managedChannel) {
        this.eventsBlockingStub = EventsGrpc.newBlockingStub((Channel)managedChannel);
        this.eventsStub = EventsGrpc.newStub((Channel)managedChannel);
    }

    public List<EventSubscriptionResponseRecord> getEvents(String sessionId, List<String> resultIds) {
        EventsCommon.EventSubscriptionRequest request = EventClient.CreateEventSubscriptionRequest(sessionId, resultIds);
        return this.mapToRecord(sessionId, request, resultIds);
    }

    private List<EventSubscriptionResponseRecord> mapToRecord(String sessionId, EventsCommon.EventSubscriptionRequest request, List<String> resultIds) {
        ArrayList<EventSubscriptionResponseRecord> responseRecords = new ArrayList<EventSubscriptionResponseRecord>();
        Iterator<EventsCommon.EventSubscriptionResponse> events = this.eventsBlockingStub.getEvents(request);
        HashSet<String> resultsExpected = new HashSet<String>(resultIds);
        while (events.hasNext()) {
            EventsCommon.EventSubscriptionResponse esr = events.next();
            resultsExpected.remove(esr.getNewResult().getResultId());
            responseRecords.add(new EventSubscriptionResponseRecord(sessionId, esr.getTaskStatusUpdate(), esr.getResultStatusUpdate(), esr.getResultOwnerUpdate(), esr.getNewTask(), esr.getNewResult()));
            if (!resultsExpected.isEmpty()) continue;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                System.out.println("Thread was interrupted while sleeping");
            }
            break;
        }
        return responseRecords;
    }

    public List<EventSubscriptionResponseRecord> getEventResponseRecords(final String sessionId, List<String> resultIds) throws InterruptedException {
        EventsCommon.EventSubscriptionRequest request = EventClient.CreateEventSubscriptionRequest(sessionId, resultIds);
        final ArrayList<EventSubscriptionResponseRecord> responseRecords = new ArrayList<EventSubscriptionResponseRecord>();
        final CountDownLatch finishLatch = new CountDownLatch(1);
        StreamObserver<EventsCommon.EventSubscriptionResponse> responseObserver = new StreamObserver<EventsCommon.EventSubscriptionResponse>(){

            public void onNext(EventsCommon.EventSubscriptionResponse esr) {
                responseRecords.add(new EventSubscriptionResponseRecord(sessionId, esr.getTaskStatusUpdate(), esr.getResultStatusUpdate(), esr.getResultOwnerUpdate(), esr.getNewTask(), esr.getNewResult()));
            }

            public void onError(Throwable t) {
                t.printStackTrace();
                finishLatch.countDown();
            }

            public void onCompleted() {
                System.out.println("Stream completed");
                finishLatch.countDown();
            }
        };
        this.eventsStub.getEvents(request, responseObserver);
        if (!finishLatch.await(1L, TimeUnit.MINUTES)) {
            System.out.println("Request not completed within the timeout.");
        }
        return responseRecords;
    }

    public static EventsCommon.EventSubscriptionRequest CreateEventSubscriptionRequest(String sessionId, List<String> resultIds) {
        FiltersCommon.FilterString filterString = FiltersCommon.FilterString.newBuilder().setOperator(FiltersCommon.FilterStringOperator.FILTER_STRING_OPERATOR_EQUAL).build();
        ResultsFields.ResultField.Builder resultField = ResultsFields.ResultField.newBuilder().setResultRawField(ResultsFields.ResultRawField.newBuilder().setField(ResultsFields.ResultRawEnumField.RESULT_RAW_ENUM_FIELD_RESULT_ID));
        ResultsFilters.FilterField.Builder filterFieldBuilder = ResultsFilters.FilterField.newBuilder().setField(resultField).setFilterString(filterString);
        ResultsFilters.Filters.Builder resultFiltersBuilder = ResultsFilters.Filters.newBuilder();
        for (String resultId : resultIds) {
            filterFieldBuilder.setFilterString(FiltersCommon.FilterString.newBuilder().setValue(resultId).build());
            resultFiltersBuilder.addOr(ResultsFilters.FiltersAnd.newBuilder().addAnd(filterFieldBuilder).build());
        }
        return EventsCommon.EventSubscriptionRequest.newBuilder().setResultsFilters(resultFiltersBuilder.build()).addReturnedEvents(EventsCommon.EventsEnum.EVENTS_ENUM_RESULT_STATUS_UPDATE).addReturnedEvents(EventsCommon.EventsEnum.EVENTS_ENUM_NEW_RESULT).setSessionId(sessionId).build();
    }
}

