/*
 * Decompiled with CFR 0.152.
 */
package armonik.client.result;

import armonik.api.grpc.v1.Objects;
import armonik.api.grpc.v1.results.ResultsCommon;
import armonik.api.grpc.v1.results.ResultsFilters;
import armonik.api.grpc.v1.results.ResultsGrpc;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResultClient {
    private final ResultsGrpc.ResultsBlockingStub resultsBlockingStub;

    public ResultClient(ManagedChannel managedChannel) {
        this.resultsBlockingStub = ResultsGrpc.newBlockingStub((Channel)managedChannel);
    }

    public int getServiceConfiguration() {
        return this.resultsBlockingStub.getServiceConfiguration(Objects.Empty.newBuilder().build()).getDataChunkMaxSize();
    }

    public List<byte[]> downloadResultData(String sessionId, String resultId) {
        ResultsCommon.DownloadResultDataRequest request = ResultsCommon.DownloadResultDataRequest.newBuilder().setSessionId(sessionId).setResultId(resultId).build();
        Iterator<ResultsCommon.DownloadResultDataResponse> iterator = this.resultsBlockingStub.downloadResultData(request);
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(list::add);
        return list.stream().map(ResultsCommon.DownloadResultDataResponse::getDataChunk).map(ByteString::toByteArray).toList();
    }

    public List<ResultsCommon.ResultRaw> createResults(ResultsCommon.CreateResultsRequest request) {
        return this.resultsBlockingStub.createResults(request).getResultsList();
    }

    public List<ResultsCommon.ResultRaw> createResultsMetaData(String sessionId, List<String> names) {
        ResultsCommon.CreateResultsMetaDataRequest request = ResultsCommon.CreateResultsMetaDataRequest.newBuilder().setSessionId(sessionId).addAllResults(names.stream().map(name -> ResultsCommon.CreateResultsMetaDataRequest.ResultCreate.newBuilder().setName((String)name).build()).toList()).build();
        return this.resultsBlockingStub.createResultsMetaData(request).getResultsList();
    }

    public Map<String, String> getOwnerTaskId(String sessionId, List<String> resultIds) {
        ResultsCommon.GetOwnerTaskIdRequest request = ResultsCommon.GetOwnerTaskIdRequest.newBuilder().setSessionId(sessionId).addAllResultId(resultIds).build();
        return this.resultsBlockingStub.getOwnerTaskId(request).getResultTaskList().stream().collect(Collectors.toMap(ResultsCommon.GetOwnerTaskIdResponse.MapResultTask::getResultId, ResultsCommon.GetOwnerTaskIdResponse.MapResultTask::getTaskId));
    }

    public ResultsCommon.ResultRaw getResult(String resultId) {
        ResultsCommon.GetResultRequest request = ResultsCommon.GetResultRequest.newBuilder().setResultId(resultId).build();
        return this.resultsBlockingStub.getResult(request).getResult();
    }

    public List<ResultsCommon.ResultRaw> listResults(ResultsFilters.Filters filters, int total, int page, int pageSize, ResultsCommon.ListResultsRequest.Sort sort) {
        ResultsCommon.ListResultsRequest request = ResultsCommon.ListResultsRequest.newBuilder().setFilters(filters).setSort(sort).setPage(page).setPageSize(pageSize).build();
        return this.resultsBlockingStub.listResults(request).getResultsList();
    }
}

