/*
 * Decompiled with CFR 0.152.
 */
package fr.diskmth.loggy;

import fr.diskmth.loggy.ANSI;
import fr.diskmth.loggy.Loggable;
import fr.diskmth.loggy.LoggyFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.logging.FileHandler;
import java.util.logging.Level;

public class LoggyFile
extends Loggable {
    protected final Path path;
    protected FileHandler fileHandler;

    public LoggyFile(String path, LoggyFormatter formatter) {
        super(formatter);
        this.path = Paths.get(path, new String[0]);
    }

    public LoggyFile(String path) {
        this(path, null);
    }

    public LoggyFile init() {
        if (this.fileHandler == null) {
            try {
                new File(this.getDir()).mkdirs();
                this.fileHandler = new FileHandler(this.path.toString(), true);
                this.fileHandler.setFormatter(LoggyFormatter.toJavaFormatter(this.formatter.getFileFormatter()));
                this.fileHandler.setLevel(Level.ALL);
                this.clearLogDir();
            }
            catch (IOException exception) {
                System.out.println(ANSI.format("Failed to initialize the log file \"%name%\"".replace("%name%", this.getPath().toString()), ANSI.RED));
                exception.printStackTrace();
            }
        }
        return this;
    }

    public LoggyFile close() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
            this.fileHandler = null;
            this.clearLogDir();
        }
        return this;
    }

    public void clearLogDir() {
        File logDir = new File(this.getDir());
        for (File emptyFile : Objects.requireNonNull(logDir.listFiles())) {
            if (emptyFile.length() != 0L) continue;
            emptyFile.delete();
        }
        logDir.delete();
    }

    public Path getPath() {
        return this.path;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public String getDir() {
        return this.path.getParent().toString();
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }
}

