/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.annotation;

import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.annotation.IPrintAnnot;
import fr.erias.iamsystem.annotation.PrintAnnot;
import fr.erias.iamsystem.annotation.Span;
import fr.erias.iamsystem.brat.IBratFormatterF;
import fr.erias.iamsystem.keywords.IKeyword;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tree.INode;
import java.util.Collection;
import java.util.List;

public class Annotation
extends Span
implements IAnnotation {
    public static IPrintAnnot printAnnot = new PrintAnnot();
    private final List<Collection<String>> algos;
    private final INode node;
    private final List<IToken> stopTokens;
    private String text;

    public static void setBratFormatter(IBratFormatterF bratFormatter) {
        printAnnot = new PrintAnnot(bratFormatter);
    }

    public static void setPrintAnnot(IPrintAnnot printAnnot) {
        Annotation.printAnnot = printAnnot;
    }

    public Annotation(List<IToken> tokens, List<Collection<String>> algos, INode node, List<IToken> stopTokens) {
        super(tokens);
        this.algos = algos;
        this.node = node;
        this.stopTokens = stopTokens;
    }

    @Override
    public int compareTo(IAnnotation o) {
        int diffStart = this.start() - o.start();
        if (diffStart != 0) {
            return diffStart;
        }
        return this.end() - o.end();
    }

    @Override
    public List<Collection<String>> getAlgos() {
        return this.algos;
    }

    @Override
    public Collection<IKeyword> getKeywords() {
        return this.node.getKeywords();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public INode lastState() {
        return this.node;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public List<IToken> stopTokens() {
        return this.stopTokens;
    }

    public String toString() {
        return printAnnot.toString(this);
    }
}

