/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.annotation;

import fr.erias.iamsystem.annotation.ISpan;
import fr.erias.iamsystem.tokenize.IOffsets;
import fr.erias.iamsystem.tokenize.IToken;
import java.util.List;

public class Span
implements IOffsets,
ISpan {
    private final List<IToken> tokens;

    public static boolean isShorterSpanOf(ISpan a, ISpan b) {
        if (a == b) {
            return false;
        }
        if (!IOffsets.offsetsOverlap(a, b)) {
            return false;
        }
        if (a.start() == b.start() && a.end() == b.end()) {
            return false;
        }
        String aSeqId = IOffsets.getSpanSeqId(a.tokens());
        String bSeqId = IOffsets.getSpanSeqId(b.tokens());
        return bSeqId.contains(aSeqId);
    }

    public Span(List<IToken> tokens) {
        this.tokens = tokens;
    }

    @Override
    public int end() {
        return this.tokens.get(this.tokens.size() - 1).end();
    }

    @Override
    public int end_i() {
        return this.tokens.get(this.tokens.size() - 1).i();
    }

    @Override
    public int start() {
        return this.tokens.get(0).start();
    }

    @Override
    public int start_i() {
        return this.tokens.get(0).i();
    }

    @Override
    public List<IToken> tokens() {
        return this.tokens;
    }
}

