/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.brat;

import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.annotation.IPrintAnnot;
import fr.erias.iamsystem.brat.BratEntity;
import fr.erias.iamsystem.brat.BratFormat;
import fr.erias.iamsystem.brat.BratFormatters;
import fr.erias.iamsystem.brat.BratNote;
import fr.erias.iamsystem.brat.IBratFormatterF;
import fr.erias.iamsystem.brat.IBratTypeF;
import fr.erias.iamsystem.brat.INoteF;
import fr.erias.iamsystem.keywords.IKeyword;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BratDocument<T extends IKeyword> {
    private final List<BratEntity> bratEntities = new ArrayList<BratEntity>();
    private final List<BratNote> bratNotes = new ArrayList<BratNote>();
    private INoteF noteFunction = annot -> IPrintAnnot.keywords2Str(annot);
    private IBratFormatterF formatter;

    public BratDocument() {
        this.formatter = BratFormatters.defaultFormatter;
    }

    public BratDocument(IBratFormatterF formatter) {
        this.formatter = formatter;
    }

    public void addAnnot(IAnnotation annot, String bratType) {
        BratFormat bratFormat = this.formatter.getFormat(annot);
        String entityId = this.getEntityId();
        BratEntity entity = new BratEntity(entityId, bratType, bratFormat.getOffsets(), bratFormat.getTextEscapeNewLine());
        this.bratEntities.add(entity);
        BratNote bratNote = new BratNote(this.getNoteId(), entityId, this.noteFunction.getNote(annot));
        this.bratNotes.add(bratNote);
    }

    public void addAnnots(Iterable<IAnnotation> annots, IBratTypeF<T> bratTypeFun) {
        for (IAnnotation annot : annots) {
            IKeyword firstKeyword = annot.getKeywords().iterator().next();
            String bratType = bratTypeFun.getBratType(firstKeyword);
            this.addAnnot(annot, bratType);
        }
    }

    public void addAnnots(Iterable<IAnnotation> annots, String bratType) {
        for (IAnnotation annot : annots) {
            this.addAnnot(annot, bratType);
        }
    }

    public String entitiesToString() {
        return this.bratEntities.stream().map(ent -> ent.toString()).collect(Collectors.joining("\n"));
    }

    public List<BratEntity> getBratEntities() {
        return this.bratEntities;
    }

    public List<BratNote> getBratNotes() {
        return this.bratNotes;
    }

    private String getEntityId() {
        return String.format("T%d", this.bratEntities.size() + 1);
    }

    public INoteF getNoteFunction() {
        return this.noteFunction;
    }

    private String getNoteId() {
        return String.format("#%d", this.bratNotes.size() + 1);
    }

    public String notesToString() {
        return this.bratNotes.stream().map(ent -> ent.toString()).collect(Collectors.joining("\n"));
    }

    public void setNoteFunction(INoteF noteFunction) {
        this.noteFunction = noteFunction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.entitiesToString());
        sb.append("\n");
        sb.append(this.notesToString());
        return sb.toString().strip();
    }
}

