/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.brat;

import fr.erias.iamsystem.annotation.IAnnotation;
import fr.erias.iamsystem.brat.BratFormat;
import fr.erias.iamsystem.brat.IBratFormatterF;
import fr.erias.iamsystem.tokenize.IOffsets;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tokenize.Offsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BratFormatters {
    public static IBratFormatterF contSeqFormatter;
    public static IBratFormatterF defaultFormatter;
    public static IBratFormatterF contSeqStopFormatter;
    public static IBratFormatterF tokenFormatter;
    public static IBratFormatterF spanFormatter;

    protected static BratFormat getBratForm(IAnnotation annot, List<List<IToken>> sequences) {
        List<IOffsets> offsets = BratFormatters.multipleSeqToOffsets(sequences);
        String seq_offsets = BratFormatters.getBratFormat(offsets);
        String seqLabel = offsets.stream().map(o -> BratFormatters.getTextSpan(annot.getText(), o)).collect(Collectors.joining(" "));
        BratFormat bratForm = new BratFormat(seqLabel, seq_offsets);
        return bratForm;
    }

    protected static String getBratFormat(IOffsets offsets) {
        return String.format("%d %d", offsets.start(), offsets.end());
    }

    protected static String getBratFormat(List<? extends IOffsets> offsets) {
        return offsets.stream().map(offset -> BratFormatters.getBratFormat(offset)).collect(Collectors.joining(";"));
    }

    protected static String getTextSpan(String text, IOffsets offsets) {
        return text.substring(offsets.start(), offsets.end());
    }

    protected static List<List<IToken>> groupContinuousSeq(List<? extends IToken> tokens) {
        if (tokens.size() == 0) {
            return new ArrayList<List<IToken>>();
        }
        tokens.sort(Comparator.naturalOrder());
        ArrayList<IToken> seq = new ArrayList<IToken>();
        seq.add(tokens.get(0));
        ArrayList<List<IToken>> sequences = new ArrayList<List<IToken>>();
        sequences.add(seq);
        for (int i = 1; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            IToken lastToken = (IToken)seq.get(seq.size() - 1);
            if (lastToken.i() + 1 == token.i()) {
                seq.add(token);
                continue;
            }
            seq = new ArrayList();
            seq.add(token);
            sequences.add(seq);
        }
        return sequences;
    }

    protected static List<IOffsets> multipleSeqToOffsets(List<List<IToken>> sequences) {
        return sequences.stream().map(t -> {
            int start = ((IToken)t.get(0)).start();
            int end = ((IToken)t.get(t.size() - 1)).end();
            Offsets offsets = new Offsets(start, end);
            return offsets;
        }).collect(Collectors.toList());
    }

    protected static List<List<IToken>> removeTrailingStopwords(List<List<IToken>> sequences, Set<Integer> stopIndices) {
        ArrayList<List<IToken>> outSeq = new ArrayList<List<IToken>>();
        for (List<IToken> seq : sequences) {
            List seqWithoutStop = seq.stream().filter(token -> !stopIndices.contains(token.i())).collect(Collectors.toList());
            if (seqWithoutStop.size() == 0) continue;
            int lastIndice = ((IToken)seqWithoutStop.get(seqWithoutStop.size() - 1)).i();
            List seqWithoutTrailingStop = seq.stream().filter(token -> token.i() <= lastIndice).collect(Collectors.toList());
            outSeq.add(seqWithoutTrailingStop);
        }
        return outSeq;
    }

    static {
        defaultFormatter = contSeqFormatter = annot -> {
            List<List<IToken>> sequences = BratFormatters.groupContinuousSeq(annot.tokens());
            return BratFormatters.getBratForm(annot, sequences);
        };
        contSeqStopFormatter = annot -> {
            ArrayList<IToken> allTokens = new ArrayList<IToken>();
            allTokens.addAll(annot.tokens());
            allTokens.addAll(annot.stopTokens());
            allTokens.sort(Comparator.naturalOrder());
            List<List<IToken>> sequences = BratFormatters.groupContinuousSeq(allTokens);
            Set<Integer> stopIndices = annot.stopTokens().stream().map(token -> token.i()).collect(Collectors.toSet());
            sequences = BratFormatters.removeTrailingStopwords(sequences, stopIndices);
            return BratFormatters.getBratForm(annot, sequences);
        };
        tokenFormatter = annot -> {
            String tokensLabel = IToken.ConcatLabel(annot.tokens());
            String offsets = BratFormatters.getBratFormat(annot.tokens());
            BratFormat bratForm = new BratFormat(tokensLabel, offsets);
            return bratForm;
        };
        spanFormatter = annot -> {
            String tokensLabel = BratFormatters.getTextSpan(annot.getText(), annot);
            String offsets = BratFormatters.getBratFormat(annot);
            BratFormat bratForm = new BratFormat(tokensLabel, offsets);
            return bratForm;
        };
    }
}

