/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy;

import fr.erias.iamsystem.fuzzy.base.NormLabelAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CacheFuzzyAlgos
extends NormLabelAlgo {
    private List<NormLabelAlgo> fuzzyAlgos;
    private Map<String, List<SynAlgo>> cache = new HashMap<String, List<SynAlgo>>();

    public CacheFuzzyAlgos() {
        this("Cache");
    }

    private CacheFuzzyAlgos(String name) {
        super(name);
        this.fuzzyAlgos = new ArrayList<NormLabelAlgo>();
    }

    public void addFuzzyAlgo(NormLabelAlgo fuzzyAlgo) {
        this.fuzzyAlgos.add(fuzzyAlgo);
    }

    private void callAlgos(String normLabel) {
        List synsAlgo = this.fuzzyAlgos.stream().map(fuzzy -> fuzzy.getSynsOfWord(normLabel)).flatMap(Collection::stream).collect(Collectors.toList());
        this.cache.put(normLabel, synsAlgo);
    }

    @Override
    public List<SynAlgo> getSynsOfWord(String normLabel) {
        if (!this.cache.containsKey(normLabel)) {
            this.callAlgos(normLabel);
        }
        return this.cache.get(normLabel);
    }
}

