/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy;

import fr.erias.iamsystem.fuzzy.base.ContextFreeAlgo;
import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.tokenize.IToken;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FuzzyRegex
extends ContextFreeAlgo {
    private final Pattern patternCompiled;
    private final List<SynAlgo> syn;

    public FuzzyRegex(String name, String pattern, String patternName) {
        super(name);
        this.patternCompiled = Pattern.compile(pattern);
        this.syn = this.word2syn(patternName);
    }

    @Override
    public List<SynAlgo> getSynonyms(IToken token) {
        Matcher matcher = this.patternCompiled.matcher(token.label());
        if (!matcher.find()) {
            return FuzzyAlgo.NO_SYN;
        }
        return this.syn;
    }

    public boolean tokenMatchesPattern(IToken token) {
        return this.wordMatchesPattern(token.label());
    }

    public boolean wordMatchesPattern(String label) {
        return this.patternCompiled.matcher(label).find();
    }
}

