/*
 * Decompiled with CFR 0.152.
 */
package fr.erias.iamsystem.fuzzy.abbreviations;

import fr.erias.iamsystem.fuzzy.abbreviations.TokenIsAnAbbFactory;
import fr.erias.iamsystem.fuzzy.abbreviations.TokenIsAnAbbreviation;
import fr.erias.iamsystem.fuzzy.base.ContextFreeAlgo;
import fr.erias.iamsystem.fuzzy.base.FuzzyAlgo;
import fr.erias.iamsystem.fuzzy.base.SynAlgo;
import fr.erias.iamsystem.tokenize.IToken;
import fr.erias.iamsystem.tokenize.ITokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Abbreviations
extends ContextFreeAlgo {
    private TokenIsAnAbbreviation abbsChecker;
    private Map<String, Set<String>> short2longForms;

    public Abbreviations(String name) {
        this(name, TokenIsAnAbbFactory.alwaysTrue);
    }

    public Abbreviations(String name, TokenIsAnAbbreviation abbsChecker) {
        super(name);
        this.abbsChecker = abbsChecker;
        this.short2longForms = new HashMap<String, Set<String>>();
    }

    public void add(String shortForm, String longForm, ITokenizer tokenizer) {
        String shortLower = this.normShortForm(shortForm);
        List<IToken> longTokens = tokenizer.tokenize(longForm);
        String longFormNorm = longTokens.stream().map(t -> t.normLabel()).collect(Collectors.joining(" "));
        if (!this.short2longForms.containsKey(shortLower)) {
            this.short2longForms.put(shortLower, new HashSet());
        }
        this.short2longForms.get(shortLower).add(longFormNorm);
    }

    @Override
    public List<SynAlgo> getSynonyms(IToken token) {
        if (!this.abbsChecker.isAnAbb(token)) {
            return FuzzyAlgo.NO_SYN;
        }
        String potentialShortForm = token.normLabel();
        String potentialNorm = this.normShortForm(potentialShortForm);
        if (this.short2longForms.containsKey(potentialNorm)) {
            Set<String> longForms = this.short2longForms.get(potentialNorm);
            return this.words2syn(longForms);
        }
        return FuzzyAlgo.NO_SYN;
    }

    private String normShortForm(String label) {
        return label.toLowerCase();
    }
}

